/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.http;

import cn.sliew.flinkful.rest.base.DataSetClient;
import cn.sliew.flinkful.rest.http.AsyncClient;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetListResponseBody;

public class DataSetHttpClient
extends AsyncClient
implements DataSetClient {
    private final String webInterfaceURL;

    public DataSetHttpClient(OkHttpClient client, String webInterfaceURL) {
        super(client);
        this.webInterfaceURL = webInterfaceURL;
    }

    @Override
    public CompletableFuture<ClusterDataSetListResponseBody> datasets() throws IOException {
        String url = this.webInterfaceURL + "/datasets";
        Request request = new Request.Builder().get().url(url).build();
        return this.remoteCall(request, ClusterDataSetListResponseBody.class);
    }

    @Override
    public CompletableFuture<TriggerResponse> deleteDataSet(String datasetId) throws IOException {
        String url = this.webInterfaceURL + "/datasets/" + datasetId;
        Request request = new Request.Builder().get().url(url).build();
        return this.remoteCall(request, TriggerResponse.class);
    }

    @Override
    public CompletableFuture<AsynchronousOperationResult<AsynchronousOperationInfo>> deleteDataSetStatus(String triggerId) throws IOException {
        String url = this.webInterfaceURL + "/datasets/delete/" + triggerId;
        Request request = new Request.Builder().get().url(url).build();
        return this.remoteCall(request, AsynchronousOperationResult.class, AsynchronousOperationInfo.class).thenApply(result -> {
            AsynchronousOperationResult type = result;
            return type;
        });
    }
}

