/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.http;

import cn.sliew.flinkful.rest.base.ClusterClient;
import cn.sliew.flinkful.rest.http.AsyncClient;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.flink.runtime.rest.handler.legacy.messages.ClusterOverviewWithVersion;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;

public class ClusterHttpClient
extends AsyncClient
implements ClusterClient {
    private final String webInterfaceURL;

    public ClusterHttpClient(OkHttpClient client, String webInterfaceURL) {
        super(client);
        this.webInterfaceURL = webInterfaceURL;
    }

    @Override
    public CompletableFuture<ClusterOverviewWithVersion> overview() throws IOException {
        String url = this.webInterfaceURL + "/overview";
        Request request = new Request.Builder().get().url(url).build();
        return this.remoteCall(request, ClusterOverviewWithVersion.class);
    }

    @Override
    public CompletableFuture<EmptyResponseBody> shutdownCluster() throws IOException {
        String url = this.webInterfaceURL + "/cluster";
        Request request = new Request.Builder().delete().url(url).build();
        return this.remoteCall(request);
    }
}

