/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.http;

import cn.sliew.flinkful.rest.http.FutureResponse;
import cn.sliew.flinkful.rest.http.util.FlinkShadedJacksonUtil;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;

public abstract class AsyncClient {
    private final OkHttpClient client;

    public AsyncClient(OkHttpClient client) {
        this.client = client;
    }

    protected CompletableFuture<EmptyResponseBody> remoteCall(Request request) throws IOException {
        FutureResponse future = new FutureResponse();
        this.client.newCall(request).enqueue((Callback)future);
        return this.map(future, json -> EmptyResponseBody.getInstance());
    }

    protected <Out, In> CompletableFuture<Out> remoteCall(Request request, Class<Out> outClass, Class<In> parameterClasses) throws IOException {
        FutureResponse future = new FutureResponse();
        this.client.newCall(request).enqueue((Callback)future);
        return this.map(future, json -> FlinkShadedJacksonUtil.parseJsonString(json, outClass, parameterClasses));
    }

    protected <T> CompletableFuture<T> remoteCall(Request request, Class<T> responseClass) throws IOException {
        FutureResponse future = new FutureResponse();
        this.client.newCall(request).enqueue((Callback)future);
        return this.map(future, json -> FlinkShadedJacksonUtil.parseJsonString(json, responseClass));
    }

    private <T> CompletableFuture<T> map(FutureResponse future, Function<String, T> parser) throws IOException {
        return future.future.thenApply(response -> {
            try {
                this.checkStatus((Response)response);
                Object r = parser.apply(response.body().string());
                return r;
            }
            catch (IOException e) {
                Rethrower.throwAs(e);
                Object var4_5 = null;
                return var4_5;
            }
            finally {
                response.close();
            }
        });
    }

    private void checkStatus(Response response) throws IOException {
        if (!response.isSuccessful()) {
            String error = String.format("code: %d, message: %s, body: %s", response.code(), response.message(), response.body().string());
            throw new RuntimeException(error);
        }
    }
}

