/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.client;

import cn.sliew.flinkful.rest.base.TaskManagerClient;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.LogListInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregateTaskManagerMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetricsResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedTaskManagerMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagerMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagerMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagersFilterQueryParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerDetailsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerDetailsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerLogsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerThreadDumpHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagersHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagersInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.ThreadDumpInfo;

public class TaskManagerRestClient
implements TaskManagerClient {
    private final String address;
    private final int port;
    private final RestClient client;

    public TaskManagerRestClient(String address, int port, RestClient client) {
        this.address = address;
        this.port = port;
        this.client = client;
    }

    @Override
    public CompletableFuture<TaskManagersInfo> taskManagers() throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)TaskManagersHeaders.getInstance());
    }

    @Override
    public CompletableFuture<AggregatedMetricsResponseBody> taskManagersMetrics(Optional<String> get, Optional<String> agg, Optional<String> taskmanagers) throws IOException {
        AggregateTaskManagerMetricsParameters parameters = new AggregateTaskManagerMetricsParameters();
        get.ifPresent(metrics -> Rethrower.toIllegalArgument(() -> parameters.metrics.resolveFromString(metrics)));
        agg.ifPresent(aggs -> Rethrower.toIllegalArgument(() -> parameters.aggs.resolveFromString(aggs)));
        taskmanagers.ifPresent(taskmanager -> Rethrower.toIllegalArgument(() -> ((TaskManagersFilterQueryParameter)parameters.selector).resolveFromString(taskmanager)));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)AggregatedTaskManagerMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<TaskManagerDetailsInfo> taskManagerDetail(String taskManagerId) throws IOException {
        TaskManagerMessageParameters parameters = new TaskManagerMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.taskManagerIdParameter.resolveFromString(taskManagerId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)TaskManagerDetailsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<LogListInfo> taskManagerLogs(String taskManagerId) throws IOException {
        TaskManagerMessageParameters parameters = new TaskManagerMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.taskManagerIdParameter.resolveFromString(taskManagerId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)TaskManagerLogsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<MetricCollectionResponseBody> taskManagerMetrics(String taskManagerId, Optional<String> get) throws IOException {
        TaskManagerMetricsMessageParameters parameters = new TaskManagerMetricsMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.taskManagerIdParameter.resolveFromString(taskManagerId));
        get.ifPresent(metrics -> Rethrower.toIllegalArgument(() -> parameters.metricsFilterParameter.resolveFromString(metrics)));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)TaskManagerMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<ThreadDumpInfo> taskManagerThreadDump(String taskManagerId) throws IOException {
        TaskManagerMessageParameters parameters = new TaskManagerMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.taskManagerIdParameter.resolveFromString(taskManagerId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)TaskManagerThreadDumpHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }
}

