/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.client;

import cn.sliew.flinkful.rest.base.SavepointClient;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointDisposalRequest;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointDisposalStatusHeaders;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointDisposalStatusMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointDisposalTriggerHeaders;

public class SavepointRestClient
implements SavepointClient {
    private final String address;
    private final int port;
    private final RestClient client;

    public SavepointRestClient(String address, int port, RestClient client) {
        this.address = address;
        this.port = port;
        this.client = client;
    }

    @Override
    public CompletableFuture<TriggerResponse> savepointDisposal(SavepointDisposalRequest request) throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SavepointDisposalTriggerHeaders.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)request);
    }

    @Override
    public CompletableFuture<AsynchronousOperationResult<AsynchronousOperationInfo>> savepointDisposalResult(String triggerId) throws IOException {
        SavepointDisposalStatusMessageParameters parameters = new SavepointDisposalStatusMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.triggerIdPathParameter.resolveFromString(triggerId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SavepointDisposalStatusHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }
}

