/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.client;

import cn.sliew.flinkful.rest.base.JobClient;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.messages.webmonitor.JobIdsWithStatusOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusMessageParameters;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingTriggerHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.JobAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.JobAccumulatorsInfo;
import org.apache.flink.runtime.rest.messages.JobAccumulatorsMessageParameters;
import org.apache.flink.runtime.rest.messages.JobCancellationHeaders;
import org.apache.flink.runtime.rest.messages.JobCancellationMessageParameters;
import org.apache.flink.runtime.rest.messages.JobConfigHeaders;
import org.apache.flink.runtime.rest.messages.JobConfigInfo;
import org.apache.flink.runtime.rest.messages.JobExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfoWithHistory;
import org.apache.flink.runtime.rest.messages.JobIdsWithStatusesOverviewHeaders;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.JobPlanHeaders;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.JobVertexAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexAccumulatorsInfo;
import org.apache.flink.runtime.rest.messages.JobVertexBackPressureHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexBackPressureInfo;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsInfo;
import org.apache.flink.runtime.rest.messages.JobVertexFlameGraphHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexFlameGraphParameters;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.JobVertexTaskManagersHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexTaskManagersInfo;
import org.apache.flink.runtime.rest.messages.JobsOverviewHeaders;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.SubtasksAllAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.SubtasksTimesHeaders;
import org.apache.flink.runtime.rest.messages.SubtasksTimesInfo;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointConfigHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointConfigInfo;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointMessageParameters;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatisticDetailsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointMessageParameters;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatisticsWithSubtaskDetails;
import org.apache.flink.runtime.rest.messages.job.JobDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.JobExecutionResultHeaders;
import org.apache.flink.runtime.rest.messages.job.JobExecutionResultResponseBody;
import org.apache.flink.runtime.rest.messages.job.JobSubmitHeaders;
import org.apache.flink.runtime.rest.messages.job.JobSubmitRequestBody;
import org.apache.flink.runtime.rest.messages.job.JobSubmitResponseBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskCurrentAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptAccumulatorsInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtasksAllAccumulatorsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedJobMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedJobMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetricsResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.JobMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexWatermarksHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobsFilterQueryParameter;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.SubtaskMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.SubtaskMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointInfo;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointStatusHeaders;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointStatusMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerHeaders;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerRequestBody;
import org.apache.flink.runtime.rest.messages.job.savepoints.stop.StopWithSavepointRequestBody;
import org.apache.flink.runtime.rest.messages.job.savepoints.stop.StopWithSavepointTriggerHeaders;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexFlameGraph;

public class JobRestClient
implements JobClient {
    private final String address;
    private final int port;
    private final RestClient client;

    public JobRestClient(String address, int port, RestClient client) {
        this.address = address;
        this.port = port;
        this.client = client;
    }

    @Override
    public CompletableFuture<MultipleJobsDetails> jobsOverview() throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobsOverviewHeaders.getInstance());
    }

    @Override
    public CompletableFuture<AggregatedMetricsResponseBody> jobsMetric(Optional<String> get, Optional<String> agg, Optional<String> jobs) throws IOException {
        AggregatedJobMetricsParameters parameters = new AggregatedJobMetricsParameters();
        get.ifPresent(metrics -> Rethrower.toIllegalArgument(() -> parameters.metrics.resolveFromString(metrics)));
        agg.ifPresent(aggs -> Rethrower.toIllegalArgument(() -> parameters.aggs.resolveFromString(aggs)));
        jobs.ifPresent(job -> Rethrower.toIllegalArgument(() -> ((JobsFilterQueryParameter)parameters.selector).resolveFromString(job)));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)AggregatedJobMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobIdsWithStatusOverview> jobs() throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobIdsWithStatusesOverviewHeaders.getInstance());
    }

    @Override
    public CompletableFuture<JobDetailsInfo> jobDetail(String jobId) throws IOException {
        JobMessageParameters parameters = new JobMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobDetailsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobSubmitResponseBody> jobSubmit(JobSubmitRequestBody requestBody) throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobSubmitHeaders.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)requestBody);
    }

    @Override
    public CompletableFuture<EmptyResponseBody> jobTerminate(String jobId, String mode) throws IOException {
        JobCancellationMessageParameters parameters = new JobCancellationMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.terminationModeQueryParameter.resolveFromString(mode));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobCancellationHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobAccumulatorsInfo> jobAccumulators(String jobId, Optional<Boolean> includeSerializedValue) throws IOException {
        JobAccumulatorsMessageParameters parameters = new JobAccumulatorsMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        includeSerializedValue.ifPresent(param -> Rethrower.toIllegalArgument(() -> parameters.includeSerializedAccumulatorsParameter.resolveFromString(param.toString())));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobAccumulatorsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<CheckpointingStatistics> jobCheckpoints(String jobId) throws IOException {
        JobMessageParameters parameters = new JobMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)CheckpointingStatisticsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<CheckpointConfigInfo> jobCheckpointConfig(String jobId) throws IOException {
        JobMessageParameters parameters = new JobMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)CheckpointConfigHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<CheckpointStatistics> jobCheckpointDetail(String jobId, Long checkpointId) throws IOException {
        CheckpointMessageParameters parameters = new CheckpointMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.checkpointIdPathParameter.resolveFromString(checkpointId.toString()));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)CheckpointStatisticDetailsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<TaskCheckpointStatisticsWithSubtaskDetails> jobCheckpointSubtaskDetail(String jobId, Long checkpointId, String vertexId) throws IOException {
        TaskCheckpointMessageParameters parameters = new TaskCheckpointMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.checkpointIdPathParameter.resolveFromString(checkpointId.toString()));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)TaskCheckpointStatisticsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobConfigInfo> jobConfig(String jobId) throws IOException {
        JobMessageParameters parameters = new JobMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobConfigHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobExceptionsInfoWithHistory> jobException(String jobId, Optional<String> maxExceptions) throws IOException {
        JobExceptionsMessageParameters parameters = new JobExceptionsMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        maxExceptions.ifPresent(param -> Rethrower.toIllegalArgument(() -> parameters.upperLimitExceptionParameter.resolveFromString(param)));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobExceptionsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobExecutionResultResponseBody> jobExecutionResult(String jobId) throws IOException {
        JobMessageParameters parameters = new JobMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobExecutionResultHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<MetricCollectionResponseBody> jobMetrics(String jobId, Optional<String> get) throws IOException {
        JobMetricsMessageParameters parameters = new JobMetricsMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        get.ifPresent(metrics -> Rethrower.toIllegalArgument(() -> parameters.metricsFilterParameter.resolveFromString(metrics)));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobPlanInfo> jobPlan(String jobId) throws IOException {
        JobMessageParameters parameters = new JobMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobPlanHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<TriggerResponse> jobRescale(String jobId, Integer parallelism) throws IOException {
        RescalingTriggerMessageParameters parameters = new RescalingTriggerMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.rescalingParallelismQueryParameter.resolveFromString(parallelism.toString()));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)RescalingTriggerHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<AsynchronousOperationResult<AsynchronousOperationInfo>> jobRescaleResult(String jobId, String triggerId) throws IOException {
        RescalingStatusMessageParameters parameters = new RescalingStatusMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.triggerIdPathParameter.resolveFromString(triggerId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)RescalingStatusHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<TriggerResponse> jobSavepoint(String jobId, SavepointTriggerRequestBody requestBody) throws IOException {
        SavepointTriggerMessageParameters parameters = new SavepointTriggerMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobID.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SavepointTriggerHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)requestBody);
    }

    @Override
    public CompletableFuture<AsynchronousOperationResult<SavepointInfo>> jobSavepointResult(String jobId, String triggerId) throws IOException {
        SavepointStatusMessageParameters parameters = new SavepointStatusMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobIdPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.triggerIdPathParameter.resolveFromString(triggerId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SavepointStatusHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<TriggerResponse> jobStop(String jobId, StopWithSavepointRequestBody requestBody) throws IOException {
        SavepointTriggerMessageParameters parameters = new SavepointTriggerMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobID.resolveFromString(jobId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)StopWithSavepointTriggerHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)requestBody);
    }

    @Override
    public CompletableFuture<JobVertexDetailsInfo> jobVertexDetail(String jobId, String vertexId) throws IOException {
        JobVertexMessageParameters parameters = new JobVertexMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobVertexDetailsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobVertexAccumulatorsInfo> jobVertexAccumulators(String jobId, String vertexId) throws IOException {
        JobVertexMessageParameters parameters = new JobVertexMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobVertexAccumulatorsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobVertexBackPressureInfo> jobVertexBackPressure(String jobId, String vertexId) throws IOException {
        JobVertexMessageParameters parameters = new JobVertexMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobVertexBackPressureHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobVertexFlameGraph> jobVertexFlameGraph(String jobId, String vertexId, String type) throws IOException {
        JobVertexFlameGraphParameters parameters = new JobVertexFlameGraphParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        Rethrower.toIllegalArgument(() -> parameters.flameGraphTypeQueryParameter.resolveFromString(type));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobVertexFlameGraphHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<MetricCollectionResponseBody> jobVertexMetrics(String jobId, String vertexId, String get) throws IOException {
        JobVertexMetricsMessageParameters parameters = new JobVertexMetricsMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        Rethrower.toIllegalArgument(() -> parameters.metricsFilterParameter.resolveFromString(get));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobVertexMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<SubtasksAllAccumulatorsInfo> jobVertexSubtaskAccumulators(String jobId, String vertexId) throws IOException {
        JobVertexMessageParameters parameters = new JobVertexMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SubtasksAllAccumulatorsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<MetricCollectionResponseBody> jobVertexSubtaskMetrics(String jobId, String vertexId, String get, String agg, String subtasks) throws IOException {
        SubtaskMetricsMessageParameters parameters = new SubtaskMetricsMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        Rethrower.toIllegalArgument(() -> parameters.metricsFilterParameter.resolveFromString(get));
        Rethrower.toIllegalArgument(() -> parameters.subtaskIndexPathParameter.resolveFromString(subtasks));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SubtaskMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<SubtaskExecutionAttemptDetailsInfo> jobVertexSubtaskDetail(String jobId, String vertexId, Integer subtaskindex) throws IOException {
        SubtaskMessageParameters parameters = new SubtaskMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        Rethrower.toIllegalArgument(() -> parameters.subtaskIndexPathParameter.resolveFromString(subtaskindex.toString()));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SubtaskCurrentAttemptDetailsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<SubtaskExecutionAttemptDetailsInfo> jobVertexSubtaskAttemptDetail(String jobId, String vertexId, Integer subtaskindex, Integer attempt) throws IOException {
        SubtaskAttemptMessageParameters parameters = new SubtaskAttemptMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        Rethrower.toIllegalArgument(() -> parameters.subtaskIndexPathParameter.resolveFromString(subtaskindex.toString()));
        Rethrower.toIllegalArgument(() -> parameters.subtaskAttemptPathParameter.resolveFromString(attempt.toString()));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SubtaskExecutionAttemptDetailsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<SubtaskExecutionAttemptAccumulatorsInfo> jobVertexSubtaskAttemptAccumulators(String jobId, String vertexId, Integer subtaskindex, Integer attempt) throws IOException {
        SubtaskAttemptMessageParameters parameters = new SubtaskAttemptMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        Rethrower.toIllegalArgument(() -> parameters.subtaskIndexPathParameter.resolveFromString(subtaskindex.toString()));
        Rethrower.toIllegalArgument(() -> parameters.subtaskAttemptPathParameter.resolveFromString(attempt.toString()));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SubtaskExecutionAttemptAccumulatorsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<MetricCollectionResponseBody> jobVertexSubtaskMetrics(String jobId, String vertexId, Integer subtaskindex, String get) throws IOException {
        SubtaskMetricsMessageParameters parameters = new SubtaskMetricsMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        Rethrower.toIllegalArgument(() -> parameters.subtaskIndexPathParameter.resolveFromString(subtaskindex.toString()));
        Rethrower.toIllegalArgument(() -> parameters.metricsFilterParameter.resolveFromString(get));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SubtaskMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<SubtasksTimesInfo> jobVertexSubtaskTimes(String jobId, String vertexId) throws IOException {
        JobVertexMessageParameters parameters = new JobVertexMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)SubtasksTimesHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobVertexTaskManagersInfo> jobVertexTaskManagers(String jobId, String vertexId) throws IOException {
        JobVertexMessageParameters parameters = new JobVertexMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobVertexTaskManagersHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<MetricCollectionResponseBody> jobVertexWatermarks(String jobId, String vertexId) throws IOException {
        JobVertexMessageParameters parameters = new JobVertexMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jobPathParameter.resolveFromString(jobId));
        Rethrower.toIllegalArgument(() -> parameters.jobVertexIdPathParameter.resolveFromString(vertexId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobVertexWatermarksHeaders.INSTANCE, (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }
}

