/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.client;

import cn.sliew.flinkful.rest.base.JobManagerClient;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.messages.ClusterConfigurationInfo;
import org.apache.flink.runtime.rest.messages.ClusterConfigurationInfoHeaders;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.LogListInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerLogListHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobManagerMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobManagerMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;

public class JobManagerRestClient
implements JobManagerClient {
    private final String address;
    private final int port;
    private final RestClient client;

    public JobManagerRestClient(String address, int port, RestClient client) {
        this.address = address;
        this.port = port;
        this.client = client;
    }

    @Override
    public CompletableFuture<ClusterConfigurationInfo> jobmanagerConfig() throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)ClusterConfigurationInfoHeaders.getInstance());
    }

    @Override
    public CompletableFuture<LogListInfo> jobmanagerLogs() throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobManagerLogListHeaders.getInstance());
    }

    @Override
    public CompletableFuture<MetricCollectionResponseBody> jobmanagerMetrics(Optional<String> get) throws IOException {
        JobManagerMetricsMessageParameters parameters = new JobManagerMetricsMessageParameters();
        get.ifPresent(metrics -> Rethrower.toIllegalArgument(() -> parameters.metricsFilterParameter.resolveFromString(metrics)));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JobManagerMetricsHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }
}

