/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.client;

import cn.sliew.flinkful.rest.base.JarClient;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.FileUpload;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarListHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarListInfo;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanGetHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarRunMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarRunRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunResponseBody;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadResponseBody;

public class JarRestClient
implements JarClient {
    private final String address;
    private final int port;
    private final RestClient client;

    public JarRestClient(String address, int port, RestClient client) {
        this.address = address;
        this.port = port;
        this.client = client;
    }

    @Override
    public CompletableFuture<JarListInfo> jars() throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JarListHeaders.getInstance());
    }

    @Override
    public CompletableFuture<JarUploadResponseBody> uploadJar(String filePath) throws IOException {
        FileUpload upload = new FileUpload(Paths.get(filePath, new String[0]), "application/octet-stream");
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JarUploadHeaders.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance(), Collections.singleton(upload));
    }

    @Override
    public CompletableFuture<EmptyResponseBody> deleteJar(String jarId) throws IOException {
        JarDeleteMessageParameters parameters = new JarDeleteMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jarIdPathParameter.resolveFromString(jarId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JarDeleteHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<JobPlanInfo> jarPlan(String jarId, JarPlanRequestBody requestBody) throws IOException {
        JarPlanMessageParameters parameters = new JarPlanMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jarIdPathParameter.resolveFromString(jarId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JarPlanGetHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)requestBody);
    }

    @Override
    public CompletableFuture<JarRunResponseBody> jarRun(String jarId, JarRunRequestBody requestBody) throws IOException {
        JarRunMessageParameters parameters = new JarRunMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.jarIdPathParameter.resolveFromString(jarId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)JarRunHeaders.getInstance(), (MessageParameters)parameters, (RequestBody)requestBody);
    }
}

