/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.client;

import cn.sliew.flinkful.rest.base.ClusterClient;
import cn.sliew.flinkful.rest.base.DashboardClient;
import cn.sliew.flinkful.rest.base.DataSetClient;
import cn.sliew.flinkful.rest.base.JarClient;
import cn.sliew.flinkful.rest.base.JobClient;
import cn.sliew.flinkful.rest.base.JobManagerClient;
import cn.sliew.flinkful.rest.base.RestClient;
import cn.sliew.flinkful.rest.base.SavepointClient;
import cn.sliew.flinkful.rest.base.TaskManagerClient;
import cn.sliew.flinkful.rest.client.ClusterRestClient;
import cn.sliew.flinkful.rest.client.DashboardRestClient;
import cn.sliew.flinkful.rest.client.DataSetRestClient;
import cn.sliew.flinkful.rest.client.JarRestClient;
import cn.sliew.flinkful.rest.client.JobManagerRestClient;
import cn.sliew.flinkful.rest.client.JobRestClient;
import cn.sliew.flinkful.rest.client.SavepointRestClient;
import cn.sliew.flinkful.rest.client.TaskManagerRestClient;
import cn.sliew.milky.common.exception.Rethrower;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

public class FlinkRestClient
implements RestClient {
    private final String address;
    private final int port;
    private final org.apache.flink.runtime.rest.RestClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(4, (ThreadFactory)new ExecutorThreadFactory("Flink-RestClusterClient-IO"));

    public FlinkRestClient(String address, int port, Configuration configuration) {
        this.address = address;
        this.port = port;
        org.apache.flink.runtime.rest.RestClient restClient = null;
        try {
            restClient = new org.apache.flink.runtime.rest.RestClient(configuration, (Executor)this.executorService);
        }
        catch (ConfigurationException e) {
            Rethrower.throwAs(e);
        }
        this.client = restClient;
    }

    @Override
    public ClusterClient cluster() {
        return new ClusterRestClient(this.address, this.port, this.client);
    }

    @Override
    public DataSetClient dataSet() {
        return new DataSetRestClient(this.address, this.port, this.client);
    }

    @Override
    public JarClient jar() {
        return new JarRestClient(this.address, this.port, this.client);
    }

    @Override
    public JobClient job() {
        return new JobRestClient(this.address, this.port, this.client);
    }

    @Override
    public JobManagerClient jobManager() {
        return new JobManagerRestClient(this.address, this.port, this.client);
    }

    @Override
    public TaskManagerClient taskManager() {
        return new TaskManagerRestClient(this.address, this.port, this.client);
    }

    @Override
    public SavepointClient savepoint() {
        return new SavepointRestClient(this.address, this.port, this.client);
    }

    @Override
    public DashboardClient dashboard() {
        return new DashboardRestClient(this.address, this.port, this.client);
    }
}

