/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.rest.client;

import cn.sliew.flinkful.rest.base.DataSetClient;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteStatusHeaders;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteStatusMessageParameters;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteTriggerHeaders;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetListHeaders;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetListResponseBody;

public class DataSetRestClient
implements DataSetClient {
    private final String address;
    private final int port;
    private final RestClient client;

    public DataSetRestClient(String address, int port, RestClient client) {
        this.address = address;
        this.port = port;
        this.client = client;
    }

    @Override
    public CompletableFuture<ClusterDataSetListResponseBody> datasets() throws IOException {
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)ClusterDataSetListHeaders.INSTANCE);
    }

    @Override
    public CompletableFuture<TriggerResponse> deleteDataSet(String datasetId) throws IOException {
        ClusterDataSetDeleteTriggerMessageParameters parameters = new ClusterDataSetDeleteTriggerMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.clusterDataSetIdPathParameter.resolveFromString(datasetId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)ClusterDataSetDeleteTriggerHeaders.INSTANCE, (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }

    @Override
    public CompletableFuture<AsynchronousOperationResult<AsynchronousOperationInfo>> deleteDataSetStatus(String triggerId) throws IOException {
        ClusterDataSetDeleteStatusMessageParameters parameters = new ClusterDataSetDeleteStatusMessageParameters();
        Rethrower.toIllegalArgument(() -> parameters.triggerIdPathParameter.resolveFromString(triggerId));
        return this.client.sendRequest(this.address, this.port, (MessageHeaders)ClusterDataSetDeleteStatusHeaders.INSTANCE, (MessageParameters)parameters, (RequestBody)EmptyRequestBody.getInstance());
    }
}

