/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.cli.frontend.example;

import cn.sliew.flinkful.cli.base.CliClient;
import cn.sliew.flinkful.cli.frontend.example.Util;
import cn.sliew.flinkful.common.enums.DeploymentTarget;
import cn.sliew.flinkful.common.examples.FlinkExamples;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;

public class NativeKubernetesApplicationExample {
    public static void main(String[] args) throws Exception {
        CliClient client = Util.buildCliClient();
        client.submitApplication(DeploymentTarget.NATIVE_KUBERNETES_APPLICATION, null, NativeKubernetesApplicationExample.buildConfiguration(), Util.buildJarJob());
    }

    private static Configuration buildConfiguration() throws MalformedURLException {
        Configuration configuration = FlinkExamples.loadConfiguration();
        configuration.setLong(JobManagerOptions.TOTAL_PROCESS_MEMORY.key(), MemorySize.ofMebiBytes((long)1024L).getBytes());
        configuration.setLong(TaskManagerOptions.TOTAL_PROCESS_MEMORY.key(), MemorySize.ofMebiBytes((long)1024L).getBytes());
        configuration.setString(KubernetesConfigOptions.CONTAINER_IMAGE, "jar-image-name");
        URL exampleUrl = new File(FlinkExamples.EXAMPLE_JAR).toURL();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, Collections.singletonList(exampleUrl), Object::toString);
        return configuration;
    }
}

