/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.system.service.impl;

import cn.sliew.carp.framework.common.dict.DictDefinition;
import cn.sliew.carp.framework.common.dict.EnumDictRegistry;
import cn.sliew.carp.module.system.service.SysDictTypeService;
import cn.sliew.carp.module.system.service.param.SysDictTypeParam;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysDictTypeServiceImpl
implements SysDictTypeService {
    @Override
    public Page<DictDefinition> listByPage(SysDictTypeParam param) {
        Collection<DictDefinition> dictTypes = this.selectAll();
        List filteredDictTypes = dictTypes.stream().filter(dictType -> {
            if (StringUtils.hasText((String)param.getCode())) {
                return dictType.getCode().contains(param.getCode());
            }
            return true;
        }).filter(dictType -> {
            if (StringUtils.hasText((String)param.getName())) {
                return dictType.getName().contains(param.getName());
            }
            return true;
        }).collect(Collectors.toList());
        Page result = new Page(param.getCurrent().longValue(), param.getPageSize().longValue(), (long)filteredDictTypes.size());
        Long from = (param.getCurrent() - 1L) * param.getPageSize();
        Long to = from + param.getPageSize();
        if (from >= (long)filteredDictTypes.size()) {
            result.setRecords(Collections.emptyList());
            return result;
        }
        result.setRecords(filteredDictTypes.subList(from.intValue(), to.intValue() < filteredDictTypes.size() ? to.intValue() : filteredDictTypes.size() - 1));
        return result;
    }

    @Override
    public Collection<DictDefinition> selectAll() {
        return EnumDictRegistry.INSTANCE.getAllDefinitions();
    }
}

