/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.system.service.impl;

import cn.sliew.carp.framework.common.dict.DictDefinition;
import cn.sliew.carp.framework.common.dict.DictInstance;
import cn.sliew.carp.framework.common.dict.EnumDictRegistry;
import cn.sliew.carp.module.system.service.SysDictService;
import cn.sliew.carp.module.system.service.SysDictTypeService;
import cn.sliew.carp.module.system.service.param.SysDictParam;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysDictServiceImpl
implements SysDictService {
    @Autowired
    private SysDictTypeService sysDictTypeService;

    @Override
    public Collection<DictInstance> selectByType(String code) {
        Optional optional = EnumDictRegistry.INSTANCE.getDictDefinition(code);
        if (optional.isPresent()) {
            return EnumDictRegistry.INSTANCE.getDictInstance((DictDefinition)optional.get());
        }
        return Collections.emptyList();
    }

    @Override
    public Page<DictInstance> listByPage(SysDictParam param) {
        Collection<DictInstance> dictInstances = param.getDictType() != null ? this.selectByType(param.getDictType()) : this.selectAll();
        List filteredDictInstances = dictInstances.stream().filter(dictInstance -> {
            if (StringUtils.hasText((String)param.getValue())) {
                return dictInstance.getValue().contains(param.getValue());
            }
            return true;
        }).filter(dictInstance -> {
            if (StringUtils.hasText((String)param.getLabel())) {
                return dictInstance.getLabel().contains(param.getLabel());
            }
            return true;
        }).collect(Collectors.toList());
        Page result = new Page(param.getCurrent().longValue(), param.getPageSize().longValue(), (long)filteredDictInstances.size());
        Long from = (param.getCurrent() - 1L) * param.getPageSize();
        Long to = from + param.getPageSize();
        if (from >= (long)filteredDictInstances.size()) {
            result.setRecords(Collections.emptyList());
            return result;
        }
        result.setRecords(filteredDictInstances.subList(from.intValue(), to.intValue() < filteredDictInstances.size() ? to.intValue() : filteredDictInstances.size() - 1));
        return result;
    }

    @Override
    public Collection<DictInstance> selectAll() {
        return EnumDictRegistry.INSTANCE.getAllInstances();
    }
}

