/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.service.impl;

import cn.sliew.carp.module.security.core.repository.entity.SecRole;
import cn.sliew.carp.module.security.core.repository.entity.SecUser;
import cn.sliew.carp.module.security.core.repository.entity.SecUserRole;
import cn.sliew.carp.module.security.core.repository.mapper.SecUserRoleMapper;
import cn.sliew.carp.module.security.core.service.SecUserRoleService;
import cn.sliew.carp.module.security.core.service.convert.SecRoleConvert;
import cn.sliew.carp.module.security.core.service.convert.SecUserConvert;
import cn.sliew.carp.module.security.core.service.dto.SecRoleDTO;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleBatchAuthorizeForUserParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleListByUserParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecUserBatchAuthorizeForRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecUserListByRoleParam;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SecUserRoleServiceImpl
extends ServiceImpl<SecUserRoleMapper, SecUserRole>
implements SecUserRoleService {
    @Override
    public Page<SecUserDTO> listAuthorizedUsersByRoleId(SecUserListByRoleParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecUser> secUserPage = ((SecUserRoleMapper)this.baseMapper).selectRelatedUsersByRole(page, param.getRoleId(), param.getStatus(), param.getUserName());
        Page result = new Page(secUserPage.getCurrent(), secUserPage.getSize(), secUserPage.getTotal());
        List secUserDTOS = SecUserConvert.INSTANCE.toDto(secUserPage.getRecords());
        result.setRecords(secUserDTOS);
        return result;
    }

    @Override
    public Page<SecUserDTO> listUnauthorizedUsersByRoleId(SecUserListByRoleParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<SecUser> secUserPage = ((SecUserRoleMapper)this.baseMapper).selectUnrelatedUsersByRole(page, param.getRoleId(), param.getStatus(), param.getUserName());
        Page result = new Page(secUserPage.getCurrent(), secUserPage.getSize(), secUserPage.getTotal());
        List secUserDTOS = SecUserConvert.INSTANCE.toDto(secUserPage.getRecords());
        result.setRecords(secUserDTOS);
        return result;
    }

    @Override
    public void authorize(SecUserBatchAuthorizeForRoleParam param) {
        ArrayList<SecUserRole> entities = new ArrayList<SecUserRole>();
        for (Long userId : param.getUserIds()) {
            SecUserRole record = new SecUserRole();
            record.setUserId(userId);
            record.setRoleId(param.getRoleId());
            entities.add(record);
        }
        this.saveBatch(entities);
    }

    @Override
    public void unauthorize(SecUserBatchAuthorizeForRoleParam param) {
        for (Long userId : param.getUserIds()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecUserRole.class).eq(SecUserRole::getUserId, (Object)userId)).eq(SecUserRole::getRoleId, (Object)param.getRoleId());
            ((SecUserRoleMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        }
    }

    @Override
    public List<SecRoleDTO> listAuthorizedRolesByUserId(SecRoleListByUserParam param) {
        List<SecRole> secRoleList = ((SecUserRoleMapper)this.baseMapper).selectRelatedRolesByUser(param.getUserId(), null, param.getName());
        return SecRoleConvert.INSTANCE.toDto(secRoleList);
    }

    @Override
    public List<SecRoleDTO> listUnauthorizedRolesByUserId(SecRoleListByUserParam param) {
        List<SecRole> secRoleList = ((SecUserRoleMapper)this.baseMapper).selectUnrelatedRolesByUser(param.getUserId(), null, param.getName());
        return SecRoleConvert.INSTANCE.toDto(secRoleList);
    }

    @Override
    public void authorize(SecRoleBatchAuthorizeForUserParam param) {
        ArrayList<SecUserRole> entities = new ArrayList<SecUserRole>();
        for (Long roleId : param.getRoleIds()) {
            SecUserRole record = new SecUserRole();
            record.setUserId(param.getUserId());
            record.setRoleId(roleId);
            entities.add(record);
        }
        this.saveBatch(entities);
    }

    @Override
    public void unauthorize(SecRoleBatchAuthorizeForUserParam param) {
        for (Long roleId : param.getRoleIds()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecUserRole.class).eq(SecUserRole::getUserId, (Object)param.getUserId())).eq(SecUserRole::getRoleId, (Object)roleId);
            ((SecUserRoleMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        }
    }
}

