/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.service.impl;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.core.util.RandomUtil;
import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.redis.RedissonUtil;
import cn.sliew.carp.module.security.core.service.SecCaptchaService;
import cn.sliew.carp.module.security.core.service.dto.SecCaptchaDTO;
import java.awt.Color;
import java.awt.Font;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SecCaptchaServiceImpl
implements SecCaptchaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecCaptchaServiceImpl.class);
    public static final String AUTH_CAPTCHA_KEY = "auth-captcha-key:";
    @Autowired
    private RedissonUtil redisUtil;

    @Override
    public SecCaptchaDTO getCaptcha() {
        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha((int)150, (int)32, (int)5, (int)RandomUtil.randomInt((int)6, (int)10));
        Font font = new Font("Stencil", 3, 20);
        lineCaptcha.setFont(font);
        lineCaptcha.setBackground(new Color(246, 250, 254));
        lineCaptcha.createCode();
        String uuid = AUTH_CAPTCHA_KEY + UUIDUtil.randomUUId();
        this.redisUtil.set(uuid, (Object)lineCaptcha.getCode(), Duration.ofMinutes(10L));
        log.info("\u9a8c\u8bc1\u7801\u6d4b\u8bd5, uuid: {}, code: {}", (Object)uuid, (Object)lineCaptcha.getCode());
        SecCaptchaDTO dto = new SecCaptchaDTO();
        dto.setUuid(uuid);
        dto.setImg(lineCaptcha.getImageBase64Data());
        return dto;
    }

    @Override
    public boolean verityCaptcha(String uuid, String authCode) {
        String redisAuthCode = (String)this.redisUtil.remove(uuid);
        return StringUtils.hasText((String)authCode) && StringUtils.hasText((String)redisAuthCode) && redisAuthCode.equalsIgnoreCase(authCode);
    }
}

