/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.controller;

import cn.sliew.carp.framework.common.security.annotations.AnonymousAccess;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.security.core.service.SecAuthenticationService;
import cn.sliew.carp.module.security.core.service.SecCaptchaService;
import cn.sliew.carp.module.security.core.service.dto.OnlineUserVO;
import cn.sliew.carp.module.security.core.service.dto.SecCaptchaDTO;
import cn.sliew.carp.module.security.core.service.param.authenticate.LoginParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/security/authentication"})
@Tag(name="\u6743\u9650\u6a21\u5757-\u8ba4\u8bc1\u7ba1\u7406")
public class SecAuthenticationController {
    @Autowired
    private SecAuthenticationService secAuthenticationService;
    @Autowired
    private SecCaptchaService secCaptchaService;

    @AnonymousAccess
    @GetMapping(value={"captcha"})
    @Operation(summary="\u83b7\u53d6\u9a8c\u8bc1\u7801", description="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    public SecCaptchaDTO getCaptcha() {
        return this.secCaptchaService.getCaptcha();
    }

    @AnonymousAccess
    @PostMapping(value={"login"})
    @Operation(summary="\u767b\u9646", description="\u767b\u9646")
    public OnlineUserVO login(@Valid @RequestBody LoginParam param, HttpServletRequest request, HttpServletResponse response) {
        return this.secAuthenticationService.login(param, request, response);
    }

    @PostMapping(value={"logout"})
    @Operation(summary="\u767b\u51fa", description="\u767b\u51fa")
    public Boolean logout(HttpServletRequest request, HttpServletResponse response) {
        return this.secAuthenticationService.logout(request, response);
    }

    @GetMapping(value={"onlineUser"})
    @Operation(summary="\u5f53\u524d\u7528\u6237", description="\u5f53\u524d\u7528\u6237")
    public OnlineUserVO getOnlineUser() {
        return this.secAuthenticationService.getOnlineUser();
    }
}

