/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.queue.api.memory;

import cn.sliew.carp.module.queue.api.ListenerManager;
import cn.sliew.carp.module.queue.api.Message;
import cn.sliew.carp.module.queue.api.MessageHandler;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

class MessageTask
implements TimerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageTask.class);
    private final Message message;
    private final ListenerManager listenerManager;

    public MessageTask(Message message, ListenerManager listenerManager) {
        this.message = message;
        this.listenerManager = listenerManager;
    }

    public void run(Timeout timeout) throws Exception {
        Map<String, List<MessageHandler>> listeners = this.listenerManager.get(this.message.getTopic());
        if (!CollectionUtils.isEmpty(listeners)) {
            for (Map.Entry<String, List<MessageHandler>> entry : listeners.entrySet()) {
                List<MessageHandler> handlers = entry.getValue();
                if (CollectionUtils.isEmpty(handlers)) continue;
                MessageHandler handler = handlers.get(0);
                try {
                    handler.handler(this.message);
                }
                catch (Exception e) {
                    if (this.message.getRetry() < this.message.getMaxRetry()) {
                        this.message.setRetry(this.message.getRetry() + 1);
                        timeout.timer().newTimeout((TimerTask)this, (long)this.message.getBackoffMills().intValue(), TimeUnit.MILLISECONDS);
                        continue;
                    }
                    log.error("message deliver error, retry , msgId: {}, topic: {}, consumerGroup: {}", new Object[]{this.message.getId(), this.message.getTopic(), entry.getKey(), e});
                }
            }
        }
    }
}

