/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.persistence.api.impl;

import cn.sliew.carp.module.persistence.api.BlobStore;
import cn.sliew.carp.module.persistence.api.PersistenceService;
import cn.sliew.carp.module.persistence.api.ResourceMapper;
import cn.sliew.carp.module.persistence.api.ResourceSerDe;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PersistenceServiceImpl<R>
implements PersistenceService<R> {
    private ResourceSerDe serDe;
    private Class<R> resourceClazz;
    private ResourceMapper<R> resourceMapper;
    private BlobStore blobStore;

    @Override
    public ResourceSerDe getSerDe() {
        return this.serDe;
    }

    @Override
    public Optional<List<R>> list() {
        List<byte[]> list = this.blobStore.list();
        return Optional.ofNullable(list).map(blobs -> blobs.stream().map(blob -> this.getSerDe().deserialize((byte[])blob, this.resourceClazz)).collect(Collectors.toList()));
    }

    @Override
    public Optional<R> get(Long id) {
        byte[] bytes = this.blobStore.get(id);
        return Optional.of(bytes).map(blob -> this.getSerDe().deserialize((byte[])blob, this.resourceClazz));
    }

    @Override
    public R add(R resource) {
        Long id = this.resourceMapper.id(resource);
        this.blobStore.add(id, this.getSerDe().serialize(resource));
        return resource;
    }

    @Override
    public R update(Long id, Function<R, R> updateFn) {
        R updated = this.get(id).map(updateFn).get();
        this.blobStore.update(id, this.getSerDe().serialize(updated));
        return updated;
    }

    @Override
    public Optional<R> delete(Long id) {
        Optional<R> optional = this.get(id);
        if (optional.isPresent()) {
            this.blobStore.delete(id);
        }
        return optional;
    }
}

