/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.watch.source.event.source.poll;

import cn.sliew.carp.module.kubernetes.watch.source.event.Event;
import cn.sliew.carp.module.kubernetes.watch.source.event.ResourceID;
import cn.sliew.carp.module.kubernetes.watch.source.event.source.AbstractResourceEventSource;
import cn.sliew.milky.common.timewheel.HashedWheelTimer;
import cn.sliew.milky.common.timewheel.Timeout;
import cn.sliew.milky.common.timewheel.TimerTask;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class BatchPollEventSource<R, P extends HasMetadata>
extends AbstractResourceEventSource<R, P> {
    private HashedWheelTimer timer;
    private Timeout timeout;
    private Supplier<Map<ResourceID, R>> resourceFetcher;
    private Duration period;

    public BatchPollEventSource(Class<R> resourceClass, Supplier<Map<ResourceID, R>> resourceFetcher, Duration period) {
        super(resourceClass);
        this.resourceFetcher = resourceFetcher;
        this.period = period;
    }

    protected void doInitialize() {
        this.timer = new HashedWheelTimer();
    }

    protected void doStart() {
        this.timer.start();
        this.timeout = this.timer.newTimeout((TimerTask)new EventProducerTask(), this.period.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        if (this.timeout != null && !this.timeout.isCancelled()) {
            this.timeout.cancel();
        }
        this.timer.stop();
    }

    private class EventProducerTask
    implements TimerTask {
        private EventProducerTask() {
        }

        public void run(Timeout timeout) throws Exception {
            Map resources = BatchPollEventSource.this.resourceFetcher.get();
            for (Map.Entry entry : resources.entrySet()) {
                BatchPollEventSource.this.getHandler().handleEvent(new Event(entry.getKey()));
            }
            timeout.task().run(timeout);
        }
    }
}

