/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.watch.source.event.source.informer;

import cn.sliew.milky.common.lifecycle.AbstractLifeCycle;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformerWrapper<T extends HasMetadata>
extends AbstractLifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InformerWrapper.class);
    private final SharedIndexInformer<T> informer;
    private final String namespace;

    public InformerWrapper(SharedIndexInformer<T> informer, String namespace) {
        this.informer = informer;
        this.namespace = namespace;
    }

    protected void doInitialize() {
    }

    protected void doStart() {
        this.informer.stopped().whenComplete((unused, throwable) -> {
            if (throwable != null) {
                log.error("informer stopped error", throwable);
            }
        });
        Class apiTypeClass = this.informer.getApiTypeClass();
        String fullResourceName = HasMetadata.getFullResourceName((Class)apiTypeClass);
        String version = HasMetadata.getVersion((Class)apiTypeClass);
        log.debug("Starting informer for namespace: {} resource: {}", (Object)this.namespace, (Object)fullResourceName);
        this.informer.start().whenComplete((unused, throwable) -> {
            if (throwable != null) {
                log.error("Start informer error for namespace: {} resource: {}", (Object)this.namespace, (Object)fullResourceName);
            } else {
                log.debug("Started informer for namespace: {} resource: {}", (Object)this.namespace, (Object)fullResourceName);
            }
        });
    }

    protected void doStop() {
        this.informer.stop();
    }

    public void addEventHandler(ResourceEventHandler<T> eventHandler) {
        this.informer.addEventHandler(eventHandler);
    }

    private String versionedFullResourceName() {
        Class apiTypeClass = this.informer.getApiTypeClass();
        if (apiTypeClass.isAssignableFrom(GenericKubernetesResource.class)) {
            return GenericKubernetesResource.class.getSimpleName();
        }
        return HasMetadata.getFullResourceName((Class)apiTypeClass) + "/" + HasMetadata.getVersion((Class)apiTypeClass);
    }
}

