/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.controller;

import cn.sliew.carp.framework.common.security.annotations.AnonymousAccess;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.kubernetes.service.entity.VersionGroupKind;
import cn.sliew.carp.module.kubernetes.watch.source.K8sSources;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.japi.function.Procedure;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/kubernetes/subscription"})
@Tag(name="Kubernetes\u6a21\u5757-\u8ba2\u9605\u7ba1\u7406")
public class K8sSubscriptionController {
    @Autowired
    private ActorSystem actorSystem;

    @AnonymousAccess
    @GetMapping(value={"start"})
    @Operation(summary="\u542f\u52a8", description="\u542f\u52a8")
    public boolean start() {
        VersionGroupKind gvk = VersionGroupKind.gvkFor(Deployment.class);
        gvk.setNamespace("default");
        KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
        CompletionStage completionStage = K8sSources.source(gvk, kubernetesClient).runForeach((Procedure & Serializable)object -> {
            ObjectMeta metadata = object.getMetadata();
            System.out.println(metadata.getNamespace() + ": " + metadata.getName());
        }, (ClassicActorSystemProvider)this.actorSystem);
        completionStage.toCompletableFuture().whenComplete((down, throwable) -> throwable.printStackTrace());
        return true;
    }

    @GetMapping(value={"stop"})
    @Operation(summary="\u505c\u6b62", description="\u505c\u6b62")
    public boolean stop() {
        return true;
    }
}

