/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.sliew.carp.module.datasource.modal.nosql;

import cn.sliew.carp.framework.common.dict.datasource.DataSourceType;
import cn.sliew.carp.framework.common.dict.datasource.RedisMode;
import cn.sliew.carp.module.datasource.modal.AbstractDataSourceProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class RedisDataSourceProperties extends AbstractDataSourceProperties {

    @NotBlank
    @Schema(description = "host")
    private String host;

    @NotNull
    @Schema(description = "port")
    private Integer port;

    @Schema(description = "user")
    private String user;

    @Schema(description = "password")
    private String password;

    @Schema(description = "redis mode, single or cluster")
    private RedisMode mode;

    @Schema(description = "redis nodes information, used in cluster mode")
    private List<Node> nodes;

    @Override
    public String getType() {
        return DataSourceType.REDIS.getValue();
    }

    @Data
    public static class Node {

        private String node;
    }
}
