/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.datasource.service.impl;

import cn.sliew.carp.framework.common.model.PageParam;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.spring.util.PageUtil;
import cn.sliew.carp.module.datasource.modal.DataSourceInfo;
import cn.sliew.carp.module.datasource.modal.jdbc.MySQLDataSourceProperties;
import cn.sliew.carp.module.datasource.service.CarpGravitinoMetalakeService;
import cn.sliew.carp.module.datasource.service.convert.GravitinoCatalogConvert;
import cn.sliew.carp.module.datasource.service.convert.GravitinoMetalakeConvert;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import cn.sliew.carp.module.datasource.service.dto.GravitinoCatalogDTO;
import cn.sliew.carp.module.datasource.service.dto.GravitinoMetalakeDTO;
import cn.sliew.carp.module.datasource.service.dto.GravitinoSchemaDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SupportsSchemas;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.file.FilesetCatalog;
import org.apache.gravitino.messaging.TopicCatalog;
import org.apache.gravitino.rel.TableCatalog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CarpGravitinoMetalakeServiceImpl
implements CarpGravitinoMetalakeService {
    @Autowired
    private GravitinoAdminClient adminClient;

    @Override
    public PageResult<GravitinoMetalakeDTO> page(PageParam param) {
        List list = GravitinoMetalakeConvert.INSTANCE.toDto(Arrays.asList(this.adminClient.listMetalakes()));
        return PageUtil.buildPage((PageParam)param, (List)list);
    }

    @Override
    public List<GravitinoCatalogDTO> listCatalogs(String metalakeName) {
        GravitinoMetalake gravitinoMetalake = this.adminClient.loadMetalake(metalakeName);
        Catalog[] catalogs = gravitinoMetalake.listCatalogsInfo();
        List catalogDTOList = Arrays.asList(catalogs).stream().map(catalog -> (CatalogDTO)catalog).collect(Collectors.toList());
        return GravitinoCatalogConvert.INSTANCE.toDto(catalogDTOList);
    }

    @Override
    public List<GravitinoSchemaDTO> listSchema(String metalakeName, String catalogName) {
        GravitinoMetalake metalake = this.adminClient.loadMetalake(metalakeName);
        Catalog catalog = metalake.loadCatalog(catalogName);
        SupportsSchemas schemas = catalog.asSchemas();
        String[] strings = schemas.listSchemas();
        Schema schema = schemas.loadSchema("schema");
        TableCatalog tableCatalog = catalog.asTableCatalog();
        TopicCatalog topicCatalog = catalog.asTopicCatalog();
        FilesetCatalog filesetCatalog = catalog.asFilesetCatalog();
        switch (catalog.type()) {
            case RELATIONAL: {
                break;
            }
            case MESSAGING: {
                break;
            }
            case FILESET: {
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return null;
    }

    @Override
    public void tryAddMetalake(String metalakeName) {
        if (!this.adminClient.metalakeExists(metalakeName)) {
            this.adminClient.createMetalake(metalakeName, "init metalake by system", Collections.emptyMap());
        }
    }

    @Override
    public void tryAddCatalog(String metalakeName, DsInfoDTO dto) {
        GravitinoMetalake metalake = this.adminClient.loadMetalake(metalakeName);
        if (!metalake.catalogExists(dto.getName())) {
            switch (dto.getDsType().getType()) {
                case MYSQL: {
                    this.initMySQL(metalake, dto.getName(), dto);
                    break;
                }
                case POSTGRESQL: {
                    break;
                }
                case HIVE: {
                    break;
                }
                case ICEBERG: {
                    break;
                }
                case DORIS: {
                    break;
                }
                case KAFKA: {
                    break;
                }
                case HDFS: {
                    break;
                }
            }
        }
    }

    private void initMySQL(GravitinoMetalake metalake, String catalogName, DsInfoDTO dsInfoDTO) {
        DataSourceInfo dataSourceInfo = (DataSourceInfo)JacksonUtil.toObject((JsonNode)JacksonUtil.toJsonNode((Object)((Object)dsInfoDTO)), DataSourceInfo.class);
        MySQLDataSourceProperties props = (MySQLDataSourceProperties)dataSourceInfo.getProps();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jdbc-driver", props.getDriverClassName());
        properties.put("jdbc-url", props.getUrl());
        properties.put("jdbc-user", props.getUser());
        properties.put("jdbc-password", props.getPassword());
        metalake.createCatalog(catalogName, Catalog.Type.RELATIONAL, "jdbc-mysql", dataSourceInfo.getRemark(), properties);
    }

    @Override
    public void tryUpdateCatalog(String metalakeName, DsInfoDTO dto) {
    }

    @Override
    public void tryDeleteCatalog(String metalakeName, DsInfoDTO dto) {
        GravitinoMetalake metalake = this.adminClient.loadMetalake(metalakeName);
    }
}

