/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sliew.carp.module.datasource.service.convert;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.module.datasource.service.dto.GravitinoMetalakeDTO;
import org.apache.gravitino.dto.MetalakeDTO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface GravitinoMetalakeConvert extends BaseConvert<MetalakeDTO, GravitinoMetalakeDTO> {
    GravitinoMetalakeConvert INSTANCE = Mappers.getMapper(GravitinoMetalakeConvert.class);

    @Override
    default GravitinoMetalakeDTO toDto(MetalakeDTO entity) {
        GravitinoMetalakeDTO dto = new GravitinoMetalakeDTO();
        dto.setName(entity.name());
        dto.setProperties(entity.properties());
        dto.setRemark(entity.comment());
        GravitinoAuditConvert.INSTANCE.copy(entity.auditInfo(), dto);
        return dto;
    }

    @Override
    default MetalakeDTO toDo(GravitinoMetalakeDTO dto) {
        throw new UnsupportedOperationException();
    }

}
