/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.application.vela.api.v1;

import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1Context;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1ContextNameResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1CreateContextValuesRequest;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1CreatePipelineRequest;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1EmptyResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1GetPipelineResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1GetPipelineRunInputResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1GetPipelineRunLogResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1GetPipelineRunOutputResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1ListContextValueResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1ListPipelineResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1ListPipelineRunResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1PipelineBase;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1PipelineMetaResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1PipelineRun;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1PipelineRunBase;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1PipelineRunMeta;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1RunPipelineRequest;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1UpdateContextValuesRequest;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1UpdatePipelineRequest;
import cn.sliew.carp.module.application.vela.api.v1.model.v1.V1alpha1WorkflowRunStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface PipelineApi {
    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/contexts"})
    public ResponseEntity<V1ListContextValueResponse> listContextValues(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2);

    @PostMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/contexts"})
    public ResponseEntity<V1Context> createContextValue(@RequestBody V1CreateContextValuesRequest var1, @PathVariable(value="projectName") String var2, @PathVariable(value="pipelineName") String var3);

    @PutMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/contexts/{contextName}"})
    public ResponseEntity<V1Context> updateContextValue(@RequestBody V1UpdateContextValuesRequest var1, @PathVariable(value="projectName") String var2, @PathVariable(value="pipelineName") String var3, @PathVariable(value="contextName") String var4);

    @DeleteMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/contexts/{contextName}"})
    public ResponseEntity<V1ContextNameResponse> deleteContextValue(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="contextName") String var3);

    @GetMapping(value={"/api/v1/pipelines"})
    public ResponseEntity<V1ListPipelineResponse> listPipelines(@RequestParam(value="query", required=false) String var1, @RequestParam(value="projectName", required=false) String var2, @RequestParam(value="detailed", required=false, defaultValue="true") Boolean var3);

    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}"})
    public ResponseEntity<V1GetPipelineResponse> getPipeline(@PathVariable(value="pipelineName") String var1, @PathVariable(value="projectName") String var2);

    @PostMapping(value={"/api/v1/projects/{projectName}/pipelines"})
    public ResponseEntity<V1PipelineBase> createPipeline(@RequestBody V1CreatePipelineRequest var1, @PathVariable(value="projectName") String var2);

    @PutMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}"})
    public ResponseEntity<V1PipelineBase> updatePipeline(@RequestBody V1UpdatePipelineRequest var1, @PathVariable(value="projectName") String var2, @PathVariable(value="pipelineName") String var3);

    @DeleteMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}"})
    public ResponseEntity<V1PipelineMetaResponse> deletePipeline(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2);

    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs"})
    public ResponseEntity<V1ListPipelineRunResponse> listPipelineRuns(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @RequestParam(value="status", required=false) String var3);

    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}"})
    public ResponseEntity<V1PipelineRunBase> getPipelineRun(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="runName") String var3);

    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}/input"})
    public ResponseEntity<V1GetPipelineRunInputResponse> getPipelineRunInput(@RequestParam(value="step", required=true) String var1, @PathVariable(value="projectName") String var2, @PathVariable(value="pipelineName") String var3, @PathVariable(value="runName") String var4);

    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}/output"})
    public ResponseEntity<V1GetPipelineRunOutputResponse> getPipelineRunOutput(@RequestParam(value="step", required=true) String var1, @PathVariable(value="projectName") String var2, @PathVariable(value="pipelineName") String var3, @PathVariable(value="runName") String var4);

    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}/log"})
    public ResponseEntity<V1GetPipelineRunLogResponse> getPipelineRunLog(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="runName") String var3, @RequestParam(value="step", required=false) String var4);

    @GetMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}/status"})
    public ResponseEntity<V1alpha1WorkflowRunStatus> getPipelineRunStatus(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="runName") String var3);

    @PostMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/run"})
    public ResponseEntity<V1PipelineRun> runPipeline(@RequestBody V1RunPipelineRequest var1, @PathVariable(value="projectName") String var2, @PathVariable(value="pipelineName") String var3);

    @PostMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}/stop"})
    public ResponseEntity<V1PipelineRunMeta> stopPipeline(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="runName") String var3);

    @PostMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}/resume"})
    public ResponseEntity<V1EmptyResponse> resumePipelineRun(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="runName") String var3, @RequestParam(value="step", required=false) String var4);

    @PostMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}/terminate"})
    public ResponseEntity<V1EmptyResponse> terminatePipelineRun(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="runName") String var3);

    @DeleteMapping(value={"/api/v1/projects/{projectName}/pipelines/{pipelineName}/runs/{runName}"})
    public ResponseEntity<V1PipelineRunMeta> deletePipelineRun(@PathVariable(value="projectName") String var1, @PathVariable(value="pipelineName") String var2, @PathVariable(value="runName") String var3);
}

