/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio;

import cn.sliew.carp.framework.queue.kekio.AbstractLifecycle;
import cn.sliew.carp.framework.queue.kekio.MessageHandler;
import cn.sliew.carp.framework.queue.kekio.Queue;
import cn.sliew.carp.framework.queue.kekio.QueueExecutor;
import cn.sliew.carp.framework.queue.kekio.QueueProcessor;
import cn.sliew.carp.framework.queue.kekio.metrics.EventPublisher;
import cn.sliew.carp.framework.queue.kekio.metrics.MonitorableQueue;
import cn.sliew.carp.framework.queue.kekio.metrics.QueueMonitor;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueue
extends AbstractLifecycle
implements Queue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractQueue.class);
    private final String name;
    private final QueueExecutor queueExecutor;
    private final Collection<MessageHandler> handlers;
    protected final List<Queue.DeadMessageCallback> deadMessageHandlers;
    protected final EventPublisher publisher;
    private MeterRegistry meterRegistry;
    private Boolean fillExecutorEachCycle;
    private Duration requeueDelay;
    private Duration requeueMaxJitter;
    protected final Boolean canPollMany;
    protected final TemporalAmount ackTimeout;
    private QueueProcessor processor;
    private QueueMonitor monitor;

    public AbstractQueue(String name, QueueExecutor queueExecutor, Collection<MessageHandler> handlers, List<Queue.DeadMessageCallback> deadMessageHandlers, EventPublisher publisher, MeterRegistry meterRegistry, Boolean fillExecutorEachCycle, Duration requeueDelay, Duration requeueMaxJitter, Boolean canPollMany, TemporalAmount ackTimeout) {
        this.name = name;
        this.queueExecutor = queueExecutor;
        this.handlers = handlers;
        this.deadMessageHandlers = deadMessageHandlers;
        this.publisher = publisher;
        this.meterRegistry = meterRegistry;
        this.fillExecutorEachCycle = Objects.nonNull(fillExecutorEachCycle) ? fillExecutorEachCycle : true;
        this.requeueDelay = Objects.nonNull(requeueDelay) ? requeueDelay : Duration.ofSeconds(0L);
        this.requeueMaxJitter = Objects.nonNull(requeueMaxJitter) ? requeueMaxJitter : Duration.ofSeconds(0L);
        this.canPollMany = Objects.nonNull(canPollMany) ? canPollMany : false;
        this.ackTimeout = Objects.nonNull(ackTimeout) ? ackTimeout : Duration.ofMinutes(1L);
    }

    @Override
    protected void doStart() throws Exception {
        this.processor = new QueueProcessor(this, this.queueExecutor, this.handlers, this.publisher, this.deadMessageHandlers, this.fillExecutorEachCycle, this.requeueDelay, this.requeueMaxJitter);
        this.processor.afterPropertiesSet();
        AbstractQueue abstractQueue = this;
        if (abstractQueue instanceof MonitorableQueue) {
            MonitorableQueue monitorableQueue = (MonitorableQueue)((Object)abstractQueue);
            this.monitor = new QueueMonitor(this.meterRegistry, monitorableQueue);
            this.monitor.afterPropertiesSet();
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.processor.destroy();
        if (Objects.nonNull(this.monitor)) {
            this.monitor.destroy();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Generated
    public QueueProcessor getProcessor() {
        return this.processor;
    }
}

