/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio.metrics;

import cn.sliew.carp.framework.queue.kekio.metrics.EventPublisher;
import cn.sliew.carp.framework.queue.kekio.metrics.QueueEvent;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class QueueMetricsPublisher
implements EventPublisher {
    private final MeterRegistry registry;
    private final String queueName;
    private final Iterable<Tag> tags;
    private final AtomicReference<Instant> _lastQueuePoll;
    private final AtomicReference<Instant> _lastRetryPoll;

    public QueueMetricsPublisher(MeterRegistry registry, String queueName) {
        this.registry = registry;
        this.queueName = queueName;
        this.tags = Tags.of((String)"queue", (String)queueName);
        this._lastQueuePoll = new AtomicReference<Instant>(Instant.now());
        this._lastRetryPoll = new AtomicReference<Instant>(Instant.now());
        registry.gauge("carp.kekio.queue.last.poll.age", this.tags, (Object)this, self -> Duration.between(self.getLastQueuePoll(), Instant.now()).toMillis());
        registry.gauge("carp.kekio.queue.last.retry.check.age", this.tags, (Object)this, self -> Duration.between(self.getLastRetryPoll(), Instant.now()).toMillis());
    }

    @Override
    public void publishEvent(QueueEvent event) {
        if (event == QueueEvent.QueuePolled) {
            this._lastQueuePoll.set(Instant.now());
        } else if (event == QueueEvent.RetryPolled) {
            this._lastRetryPoll.set(Instant.now());
        } else if (event instanceof QueueEvent.MessageProcessing) {
            QueueEvent.MessageProcessing mp = (QueueEvent.MessageProcessing)event;
            this.getMessageLagTimer().record(mp.getLag().toMillis(), TimeUnit.MILLISECONDS);
        } else if (event instanceof QueueEvent.MessagePushed) {
            this.getMessagePushedCounter().increment();
        } else if (event == QueueEvent.MessageAcknowledged) {
            this.getMessageAcknowledgedCounter().increment();
        } else if (event == QueueEvent.MessageRetried) {
            this.getMessageRetriedCounter().increment();
        } else if (event == QueueEvent.MessageDead) {
            this.getMessageDeadCounter().increment();
        } else if (event instanceof QueueEvent.MessageDuplicate) {
            QueueEvent.MessageDuplicate md = (QueueEvent.MessageDuplicate)event;
            this.getMessageDuplicateCounter(md).increment();
        } else if (event == QueueEvent.LockFailed) {
            this.getLockFailedCounter().increment();
        } else if (event instanceof QueueEvent.MessageRescheduled) {
            this.getMessageRescheduledCounter().increment();
        } else if (event instanceof QueueEvent.MessageNotFound) {
            this.getMessageNotFoundCounter().increment();
        }
    }

    private Timer getMessageLagTimer() {
        return this.registry.timer("carp.kekio.queue.message.lag", this.tags);
    }

    private Counter getMessagePushedCounter() {
        return this.registry.counter("carp.kekio.queue.pushed.messages", this.tags);
    }

    private Counter getMessageAcknowledgedCounter() {
        return this.registry.counter("carp.kekio.queue.acknowledged.messages", this.tags);
    }

    private Counter getMessageRetriedCounter() {
        return this.registry.counter("carp.kekio.queue.retried.messages", this.tags);
    }

    private Counter getMessageDeadCounter() {
        return this.registry.counter("carp.kekio.queue.dead.messages", this.tags);
    }

    private Counter getMessageDuplicateCounter(QueueEvent.MessageDuplicate event) {
        return this.registry.counter("carp.kekio.queue.duplicate.messages", (Iterable)Tags.concat(this.tags, (String[])new String[]{"messageType", event.getPayload().getClass().getSimpleName()}));
    }

    private Counter getLockFailedCounter() {
        return this.registry.counter("carp.kekio.queue.lock.failed", this.tags);
    }

    private Counter getMessageRescheduledCounter() {
        return this.registry.counter("carp.kekio.queue.reschedule.succeeded", this.tags);
    }

    private Counter getMessageNotFoundCounter() {
        return this.registry.counter("carp.kekio.queue.message.notfound", this.tags);
    }

    public Instant getLastQueuePoll() {
        return this._lastQueuePoll.get();
    }

    public Instant getLastRetryPoll() {
        return this._lastRetryPoll.get();
    }
}

