/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.carp.framework.queue.kekio.MessageHandler;
import cn.sliew.carp.framework.queue.kekio.Queue;
import cn.sliew.carp.framework.queue.kekio.QueueContextHolder;
import cn.sliew.carp.framework.queue.kekio.QueueExecutor;
import cn.sliew.carp.framework.queue.kekio.message.AttemptsAttribute;
import cn.sliew.carp.framework.queue.kekio.message.Message;
import cn.sliew.carp.framework.queue.kekio.metrics.EventPublisher;
import cn.sliew.carp.framework.queue.kekio.metrics.QueueEvent;
import cn.sliew.milky.common.util.JacksonUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class QueueProcessor
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueProcessor.class);
    private Queue queue;
    private QueueExecutor<?> executor;
    private final Collection<MessageHandler> handlers;
    private EventPublisher publisher;
    private List<Queue.DeadMessageCallback> deadMessageHandlers;
    private Boolean fillExecutorEachCycle;
    private Duration requeueDelay;
    private Duration requeueMaxJitter;
    private final Random random = new Random();
    private final Map<Class<? extends Message>, MessageHandler> handlerCache = new HashMap<Class<? extends Message>, MessageHandler>();
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private final Queue.QueueCallback callback = (message, ack) -> {
        log.debug("Received message, queue: {}, message: {}", (Object)this.queue.getName(), (Object)JacksonUtil.toJsonString((Object)message));
        MessageHandler<?> handler = this.handlerFor(message);
        if (handler != null) {
            try {
                this.executor.execute(() -> {
                    try {
                        QueueContextHolder.set(message);
                        handler.invoke(message);
                        ack.run();
                    }
                    catch (Throwable e) {
                        log.error("Unhandled throwable from {}", (Object)message, (Object)e);
                        this.publisher.publishEvent(new QueueEvent.HandlerThrewError(message));
                    }
                    finally {
                        QueueContextHolder.clear();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                long requeueDelaySeconds = this.requeueDelay.getSeconds();
                if (this.requeueMaxJitter.getSeconds() > 0L) {
                    requeueDelaySeconds += (long)this.random.nextInt((int)this.requeueMaxJitter.getSeconds());
                }
                Duration requeueDelay = Duration.ofSeconds(requeueDelaySeconds);
                AttemptsAttribute numberOfAttempts = message.getAttribute(AttemptsAttribute.class);
                log.warn("Executor at capacity, re-queuing message {} (delay: {}, attempts: {})", new Object[]{message, requeueDelay, numberOfAttempts, e});
                this.queue.push(message, requeueDelay);
            }
        } else {
            log.error("Unsupported message type {}: {}", (Object)message.getClass().getSimpleName(), (Object)message);
            if (CollectionUtils.isNotEmpty(this.deadMessageHandlers)) {
                for (Queue.DeadMessageCallback deadMessageHandler : this.deadMessageHandlers) {
                    deadMessageHandler.accept(this.queue, message);
                }
            }
            this.publisher.publishEvent(QueueEvent.MessageDead);
        }
    };

    public QueueProcessor(Queue queue, QueueExecutor<?> executor, EventPublisher publisher, List<Queue.DeadMessageCallback> deadMessageHandlers, Boolean fillExecutorEachCycle, Duration requeueDelay, Duration requeueMaxJitter) {
        this(queue, executor, new ArrayList<MessageHandler>(SpringUtil.getBeansOfType(MessageHandler.class).values()), publisher, deadMessageHandlers, fillExecutorEachCycle, requeueDelay, requeueMaxJitter);
    }

    public QueueProcessor(Queue queue, QueueExecutor<?> executor, Collection<MessageHandler> handlers, EventPublisher publisher, List<Queue.DeadMessageCallback> deadMessageHandlers, Boolean fillExecutorEachCycle, Duration requeueDelay, Duration requeueMaxJitter) {
        this.queue = queue;
        this.executor = executor;
        this.handlers = CollectionUtils.isEmpty(handlers) ? new ArrayList<MessageHandler>() : new ArrayList<MessageHandler>(handlers);
        this.publisher = publisher;
        this.deadMessageHandlers = deadMessageHandlers;
        this.fillExecutorEachCycle = Objects.nonNull(fillExecutorEachCycle) ? fillExecutorEachCycle : true;
        this.requeueDelay = Objects.nonNull(requeueDelay) ? requeueDelay : Duration.ofSeconds(0L);
        this.requeueMaxJitter = Objects.nonNull(requeueMaxJitter) ? requeueMaxJitter : Duration.ofSeconds(0L);
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduledExecutor = ThreadUtil.createScheduledExecutor((int)1);
        ThreadUtil.schedule((ScheduledThreadPoolExecutor)this.scheduledExecutor, () -> this.poll(), (long)0L, (long)50L, (boolean)false);
        log.debug("Start process queue poll: {}", (Object)this.queue.getClass().getSimpleName());
    }

    public void destroy() throws Exception {
        if (Objects.nonNull(this.scheduledExecutor)) {
            this.scheduledExecutor.shutdown();
            log.info("Stop process queue poll: {}", (Object)this.queue.getClass().getSimpleName());
        }
    }

    private void poll() {
        if (this.executor.hasCapacity()) {
            if (this.fillExecutorEachCycle.booleanValue()) {
                if (this.queue.canPollMany().booleanValue()) {
                    this.queue.poll(this.executor.availableCapacity(), this.callback);
                } else {
                    for (int i = this.executor.availableCapacity().intValue(); i > 0; --i) {
                        this.pollOnce();
                    }
                }
            } else {
                this.pollOnce();
            }
        } else {
            this.publisher.publishEvent(QueueEvent.NoHandlerCapacity);
        }
    }

    private void pollOnce() {
        this.queue.poll(this.callback);
    }

    private MessageHandler<?> handlerFor(Message message) {
        return this.handlerCache.computeIfAbsent(message.getClass(), key -> this.handlers.stream().filter(handler -> handler.getMessageType().isAssignableFrom((Class<?>)key)).findFirst().orElse(null));
    }

    public void addMessageHandler(MessageHandler<?> handler) {
        this.handlers.add(handler);
    }

    public void removeMessageHandler(MessageHandler<?> handler) {
        this.handlers.remove(handler);
    }
}

