/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sliew.carp.framework.queue.kekio.configuration;

import cn.sliew.carp.framework.spring.jackson.StringSubtypeLocator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;
import java.util.Map;

@Setter
@Getter
@ConfigurationProperties(prefix = KekioObjectMapperSubtypeProperties.PREFIX)
public class KekioObjectMapperSubtypeProperties {

    public static final String PREFIX = KekioQueueProperties.PREFIX + ".object-mapper";

    private StringSubtypeLocator messageSubtypeLocator;
    private StringSubtypeLocator attributeSubtypeLocator;
    private List<StringSubtypeLocator> extraSubtypeLocators = Lists.newArrayList();

    private String messageRootType = "cn.sliew.carp.framework.queue.kekio.message.Message";
    private List<String> messagePackages = Lists.newArrayList("cn.sliew.carp.framework.queue.kekio.message");

    private String attributeRootType = "cn.sliew.carp.framework.queue.kekio.message.Attribute";
    private List<String> attributePackages = Lists.newArrayList("cn.sliew.carp.framework.queue.kekio.message");

    private Map<String, List<String>> extraSubtypes = Maps.newHashMap();
}
