/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio.configuration;

import cn.sliew.carp.framework.queue.kekio.configuration.KekioObjectMapperSubtypeProperties;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={KekioObjectMapperSubtypeProperties.class})
public class KekioObjectMapperConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KekioObjectMapperConfiguration.class);
    public static final String KEKIO_OBJECT_MAPPER = "cn.sliew.carp.framework.queue.kekio.configuration.KekioObjectMapper";
    @Autowired
    private KekioObjectMapperSubtypeProperties properties;

    @Bean(name={"cn.sliew.carp.framework.queue.kekio.configuration.KekioObjectMapper"})
    public ObjectMapper kekioObjectMapper() {
        ObjectMapper mapper = JacksonUtil.getMapper().copy();
        this.registerSubtypes(mapper, this.properties.getMessageRootType(), this.properties.getMessagePackages());
        this.registerSubtypes(mapper, this.properties.getAttributeRootType(), this.properties.getAttributePackages());
        this.properties.getExtraSubtypes().forEach((rootType, subtypePackages) -> this.registerSubtypes(mapper, (String)rootType, (List<String>)subtypePackages));
        return mapper;
    }

    private void registerSubtypes(ObjectMapper mapper, String rootType, List<String> subtypePackages) {
        Class rootTypeClass = this.getRootTypeClass(rootType);
        subtypePackages.forEach(it -> mapper.registerSubtypes(this.findSubtypes(rootTypeClass, (String)it)));
    }

    private NamedType[] findSubtypes(Class rootTypeClass, String packageName) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(rootTypeClass));
        Set candidateComponents = provider.findCandidateComponents(packageName);
        return (NamedType[])candidateComponents.stream().map(it -> {
            Class clazz;
            JsonTypeName annotation;
            if (StringUtils.isNotBlank((CharSequence)it.getBeanClassName()) && Objects.nonNull(annotation = (clazz = ClassUtils.resolveClassName((String)it.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader())).getAnnotation(JsonTypeName.class))) {
                if (StringUtils.isBlank((CharSequence)annotation.value())) {
                    throw new RuntimeException(String.format("Subtype %s does not have a JsonTypeName", clazz.getSimpleName()));
                }
                log.info("Registering subtype of {}: {} to KekioObjectMapper", (Object)clazz.getSimpleName(), (Object)annotation.value());
                return new NamedType(clazz, annotation.value());
            }
            return null;
        }).filter(it -> Objects.nonNull(it)).toArray(NamedType[]::new);
    }

    private Class getRootTypeClass(String name) {
        return ClassUtils.resolveClassName((String)name, (ClassLoader)ClassUtils.getDefaultClassLoader());
    }
}

