/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio.metrics;

import cn.hutool.core.thread.ThreadUtil;
import cn.sliew.carp.framework.queue.kekio.metrics.MonitorableQueue;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class QueueMonitor
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueMonitor.class);
    private final MonitorableQueue queue;
    private final AtomicReference<MonitorableQueue.QueueState> _lastState;
    private ScheduledThreadPoolExecutor scheduledExecutor;

    public QueueMonitor(MeterRegistry registry, MonitorableQueue queue) {
        this.queue = queue;
        this._lastState = new AtomicReference<MonitorableQueue.QueueState>(new MonitorableQueue.QueueState(0, 0, 0));
        registry.gauge("queue.depth", (Object)this, monitor -> monitor.getLastState().getDepth().intValue());
        registry.gauge("queue.unacked.depth", (Object)this, monitor -> monitor.getLastState().getUnacked().intValue());
        registry.gauge("queue.ready.depth", (Object)this, monitor -> monitor.getLastState().getReady().intValue());
        registry.gauge("queue.orphaned.messages", (Object)this, monitor -> monitor.getLastState().getOrphaned().intValue());
    }

    public MonitorableQueue.QueueState getLastState() {
        return this._lastState.get();
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduledExecutor = ThreadUtil.createScheduledExecutor((int)1);
        ThreadUtil.schedule((ScheduledThreadPoolExecutor)this.scheduledExecutor, () -> this.pollQueueState(), (long)0L, (long)30000L, (boolean)false);
        log.debug("Start monitor queue: {}", (Object)this.queue.getClass().getSimpleName());
    }

    public void destroy() throws Exception {
        if (Objects.nonNull(this.scheduledExecutor)) {
            this.scheduledExecutor.shutdown();
            log.debug("Stop monitor queue: {}", (Object)this.queue.getClass().getSimpleName());
        }
    }

    private void pollQueueState() {
        this._lastState.set(this.queue.readState());
    }
}

