/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio.metrics;

import cn.sliew.carp.framework.queue.kekio.metrics.EventPublisher;
import cn.sliew.carp.framework.queue.kekio.metrics.QueueEvent;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class QueueMetricsPublisher
implements EventPublisher {
    private final MeterRegistry registry;
    private final AtomicReference<Instant> _lastQueuePoll;
    private final AtomicReference<Instant> _lastRetryPoll;

    public QueueMetricsPublisher(MeterRegistry registry) {
        this.registry = registry;
        this._lastQueuePoll = new AtomicReference<Instant>(Instant.now());
        this._lastRetryPoll = new AtomicReference<Instant>(Instant.now());
        registry.gauge("queue.last.poll.age", (Object)this, self -> Duration.between(self.getLastQueuePoll(), Instant.now()).toMillis());
        registry.gauge("queue.last.retry.check.age", (Object)this, self -> Duration.between(self.getLastRetryPoll(), Instant.now()).toMillis());
    }

    @Override
    public void publishEvent(QueueEvent event) {
        if (event == QueueEvent.QueuePolled) {
            this._lastQueuePoll.set(Instant.now());
        } else if (event instanceof QueueEvent.MessageProcessing) {
            QueueEvent.MessageProcessing mp = (QueueEvent.MessageProcessing)event;
            this.registry.timer("queue.message.lag", new String[0]).record(mp.getLag().toMillis(), TimeUnit.MILLISECONDS);
        } else if (event == QueueEvent.RetryPolled) {
            this._lastRetryPoll.set(Instant.now());
        } else if (event instanceof QueueEvent.MessagePushed) {
            this.getMessagePushedCounter().increment();
        } else if (event == QueueEvent.MessageAcknowledged) {
            this.getMessageAcknowledgedCounter().increment();
        } else if (event == QueueEvent.MessageRetried) {
            this.getMessageRetriedCounter().increment();
        } else if (event == QueueEvent.MessageDead) {
            this.getMessageDeadCounter().increment();
        } else if (event instanceof QueueEvent.MessageDuplicate) {
            QueueEvent.MessageDuplicate md = (QueueEvent.MessageDuplicate)event;
            this.getMessageDuplicateCounter(md).increment();
        } else if (event == QueueEvent.LockFailed) {
            this.getLockFailedCounter().increment();
        } else if (event instanceof QueueEvent.MessageRescheduled) {
            this.getMessageRescheduledCounter().increment();
        } else if (event instanceof QueueEvent.MessageNotFound) {
            this.getMessageNotFoundCounter().increment();
        }
    }

    private Counter getMessagePushedCounter() {
        return this.registry.counter("queue.pushed.messages", new String[0]);
    }

    private Counter getMessageAcknowledgedCounter() {
        return this.registry.counter("queue.acknowledged.messages", new String[0]);
    }

    private Counter getMessageRetriedCounter() {
        return this.registry.counter("queue.retried.messages", new String[0]);
    }

    private Counter getMessageDeadCounter() {
        return this.registry.counter("queue.dead.messages", new String[0]);
    }

    private Counter getMessageDuplicateCounter(QueueEvent.MessageDuplicate event) {
        return this.registry.counter("queue.duplicate.messages", new String[]{"messageType", event.getPayload().getClass().getSimpleName()});
    }

    private Counter getLockFailedCounter() {
        return this.registry.counter("queue.lock.failed", new String[0]);
    }

    private Counter getMessageRescheduledCounter() {
        return this.registry.counter("queue.reschedule.succeeded", new String[0]);
    }

    private Counter getMessageNotFoundCounter() {
        return this.registry.counter("queue.message.notfound", new String[0]);
    }

    public Instant getLastQueuePoll() {
        return this._lastQueuePoll.get();
    }

    public Instant getLastRetryPoll() {
        return this._lastRetryPoll.get();
    }
}

