/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio.configuration;

import cn.sliew.carp.framework.queue.kekio.Queue;
import cn.sliew.carp.framework.queue.kekio.QueueExecutor;
import cn.sliew.carp.framework.queue.kekio.ThreadPoolQueueExecutor;
import cn.sliew.carp.framework.queue.kekio.configuration.KekioObjectMapperConfiguration;
import cn.sliew.carp.framework.queue.kekio.configuration.KekioQueueProperties;
import cn.sliew.carp.framework.queue.kekio.memory.InMemoryQueue;
import cn.sliew.carp.framework.queue.kekio.metrics.EventPublisher;
import cn.sliew.carp.framework.queue.kekio.metrics.QueueMetricsPublisher;
import cn.sliew.carp.framework.queue.kekio.redis.JedisClusterQueue;
import cn.sliew.carp.framework.queue.kekio.redis.JedisQueue;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.Pool;

@AutoConfiguration
@AutoConfigureAfter(value={KekioObjectMapperConfiguration.class})
@EnableConfigurationProperties(value={KekioQueueProperties.class})
public class KekioQueueAutoConfiguration {
    @Autowired
    private KekioQueueProperties properties;

    @Bean
    public QueueExecutor<ThreadPoolTaskExecutor> queueExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("keiko-queue-processor-");
        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors());
        executor.setMaxPoolSize(Runtime.getRuntime().availableProcessors() * 2);
        executor.setQueueCapacity(1024);
        executor.setKeepAliveSeconds((int)Duration.ofMinutes(1L).toSeconds());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return new ThreadPoolQueueExecutor(executor);
    }

    @Bean
    public EventPublisher eventPublisher(MeterRegistry registry) {
        return new QueueMetricsPublisher(registry);
    }

    @Bean
    @ConditionalOnProperty(prefix="carp.framework.queue.kekio", value={"type"}, havingValue="MEM", matchIfMissing=false)
    public InMemoryQueue inMemoryKekioQueue(QueueExecutor queueExecutor, List<Queue.DeadMessageCallback> deadMessageHandlers, EventPublisher eventPublisher, MeterRegistry meterRegistry) {
        return new InMemoryQueue(queueExecutor, deadMessageHandlers, eventPublisher, meterRegistry, null, null, null, null, null);
    }

    @Bean
    @ConditionalOnBean(value={Pool.class})
    @ConditionalOnProperty(prefix="carp.framework.queue.kekio", value={"type"}, havingValue="JEDIS", matchIfMissing=false)
    public JedisQueue jedisKekioQueue(JedisPool jedisPool, @Qualifier(value="cn.sliew.carp.framework.queue.kekio.configuration.KekioObjectMapper") ObjectMapper objectMapper, QueueExecutor queueExecutor, List<Queue.DeadMessageCallback> deadMessageHandlers, EventPublisher eventPublisher, MeterRegistry meterRegistry) {
        return new JedisQueue((Pool<Jedis>)jedisPool, this.properties.getName(), objectMapper, queueExecutor, deadMessageHandlers, eventPublisher, meterRegistry, null, null, null, null, null, null);
    }

    @Bean
    @ConditionalOnBean(value={JedisCluster.class})
    @ConditionalOnProperty(prefix="carp.framework.queue.kekio", value={"type"}, havingValue="JEDIS_CLUSTER", matchIfMissing=false)
    public JedisClusterQueue jedisClusterKekioQueue(JedisCluster jedisCluster, @Qualifier(value="cn.sliew.carp.framework.queue.kekio.configuration.KekioObjectMapper") ObjectMapper objectMapper, QueueExecutor queueExecutor, List<Queue.DeadMessageCallback> deadMessageHandlers, EventPublisher eventPublisher, MeterRegistry meterRegistry) {
        return new JedisClusterQueue(jedisCluster, this.properties.getName(), objectMapper, queueExecutor, deadMessageHandlers, eventPublisher, meterRegistry, null, null, null, null, null, null);
    }
}

