/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio;

import cn.sliew.carp.framework.queue.kekio.message.Message;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import org.springframework.context.SmartLifecycle;

public interface Queue
extends SmartLifecycle {
    public static final int MAX_RETRIES = 5;

    public void poll(QueueCallback var1);

    default public void poll(int maxMessages, QueueCallback callback) {
        for (int i = 0; i < maxMessages; ++i) {
            this.poll(callback);
        }
    }

    default public void push(Message message) {
        this.push(message, Duration.ZERO);
    }

    public void push(Message var1, TemporalAmount var2);

    default public void retry() {
    }

    default public void clear() {
    }

    public TemporalAmount getAckTimeout();

    public List<DeadMessageCallback> getDeadMessageHandlers();

    public Boolean canPollMany();

    @FunctionalInterface
    public static interface QueueCallback {
        public void accept(Message var1, Runnable var2);
    }

    @FunctionalInterface
    public static interface DeadMessageCallback {
        public void accept(Queue var1, Message var2);
    }
}

