/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.queue.kekio;

import cn.sliew.carp.framework.queue.kekio.Queue;
import cn.sliew.carp.framework.queue.kekio.QueueExecutor;
import cn.sliew.carp.framework.queue.kekio.QueueProcessor;
import cn.sliew.carp.framework.queue.kekio.metrics.EventPublisher;
import cn.sliew.carp.framework.queue.kekio.metrics.MonitorableQueue;
import cn.sliew.carp.framework.queue.kekio.metrics.QueueMonitor;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueue
implements Queue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractQueue.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private ReentrantLock lifecycleLock = new ReentrantLock();
    private QueueExecutor queueExecutor;
    protected final List<Queue.DeadMessageCallback> deadMessageHandlers;
    protected final EventPublisher publisher;
    private MeterRegistry meterRegistry;
    private Boolean fillExecutorEachCycle;
    private Duration requeueDelay;
    private Duration requeueMaxJitter;
    protected final Boolean canPollMany;
    protected final TemporalAmount ackTimeout;
    private QueueProcessor processor;
    private QueueMonitor monitor;

    public AbstractQueue(QueueExecutor queueExecutor, List<Queue.DeadMessageCallback> deadMessageHandlers, EventPublisher publisher, MeterRegistry meterRegistry, Boolean fillExecutorEachCycle, Duration requeueDelay, Duration requeueMaxJitter, Boolean canPollMany, TemporalAmount ackTimeout) {
        this.queueExecutor = queueExecutor;
        this.deadMessageHandlers = deadMessageHandlers;
        this.publisher = publisher;
        this.meterRegistry = meterRegistry;
        this.fillExecutorEachCycle = Objects.nonNull(fillExecutorEachCycle) ? fillExecutorEachCycle : true;
        this.requeueDelay = Objects.nonNull(requeueDelay) ? requeueDelay : Duration.ofSeconds(0L);
        this.requeueMaxJitter = Objects.nonNull(requeueMaxJitter) ? requeueMaxJitter : Duration.ofSeconds(0L);
        this.canPollMany = Objects.nonNull(canPollMany) ? canPollMany : false;
        this.ackTimeout = Objects.nonNull(ackTimeout) ? ackTimeout : Duration.ofMinutes(1L);
    }

    public void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.isRunning()) {
                this.processor = new QueueProcessor(this, this.queueExecutor, this.publisher, this.deadMessageHandlers, this.fillExecutorEachCycle, this.requeueDelay, this.requeueMaxJitter);
                this.processor.afterPropertiesSet();
                AbstractQueue abstractQueue = this;
                if (abstractQueue instanceof MonitorableQueue) {
                    MonitorableQueue monitorableQueue = (MonitorableQueue)((Object)abstractQueue);
                    this.monitor = new QueueMonitor(this.meterRegistry, monitorableQueue);
                    this.monitor.afterPropertiesSet();
                }
                this.running.compareAndSet(false, true);
            }
        }
        catch (Exception e) {
            log.error("Start queue error", (Throwable)e);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.lifecycleLock.lock();
            try {
                this.processor.destroy();
                if (Objects.nonNull(this.monitor)) {
                    this.monitor.destroy();
                }
                this.running.compareAndSet(true, false);
            }
            catch (Exception e) {
                log.error("Stop queue error", (Throwable)e);
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

