/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.pubsub.queue.kekio;

import cn.sliew.carp.framework.pubsub.model.AbstractPubsubChannelFactory;
import cn.sliew.carp.framework.pubsub.model.PubsubChannel;
import cn.sliew.carp.framework.pubsub.model.PubsubChannelFactory;
import cn.sliew.carp.framework.pubsub.queue.kekio.QueuePubsubChannel;
import cn.sliew.carp.framework.queue.kekio.Queue;
import cn.sliew.carp.framework.queue.kekio.QueueExecutor;
import cn.sliew.carp.framework.queue.kekio.metrics.EventPublisher;
import cn.sliew.carp.framework.queue.kekio.metrics.QueueMetricsPublisher;
import cn.sliew.carp.framework.queue.kekio.redis.JedisQueue;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.Pool;

public class QueuePubsubChannelFactory
extends AbstractPubsubChannelFactory
implements PubsubChannelFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueuePubsubChannelFactory.class);
    public static final String SYSTEM = "kekio-queue";
    private final JedisPool jedisPool;
    private final ObjectMapper objectMapper;
    private final QueueExecutor queueExecutor;
    private final List<Queue.DeadMessageCallback> deadMessageHandlers;
    private final MeterRegistry meterRegistry;

    public QueuePubsubChannelFactory(JedisPool jedisPool, ObjectMapper objectMapper, QueueExecutor queueExecutor, List<Queue.DeadMessageCallback> deadMessageHandlers, MeterRegistry meterRegistry) {
        this.jedisPool = jedisPool;
        this.objectMapper = objectMapper;
        this.queueExecutor = queueExecutor;
        this.deadMessageHandlers = deadMessageHandlers;
        this.meterRegistry = meterRegistry;
    }

    public String getSystem() {
        return SYSTEM;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        Collection pubsubChannels = this.getAll();
        if (CollectionUtils.isNotEmpty((Collection)pubsubChannels)) {
            for (PubsubChannel pubsubChannel : pubsubChannels) {
                try {
                    pubsubChannel.stop();
                }
                catch (Exception e) {
                    log.error("Stop pubsub channel error", (Throwable)e);
                }
            }
        }
    }

    protected PubsubChannel doCreate(String name) {
        JedisQueue jedisQueue = new JedisQueue((Pool)this.jedisPool, this.objectMapper, name, this.queueExecutor, null, this.deadMessageHandlers, (EventPublisher)new QueueMetricsPublisher(this.meterRegistry, name), this.meterRegistry, null, null, null, null, null, null);
        QueuePubsubChannel pubsubChannel = new QueuePubsubChannel(name, (Queue)jedisQueue);
        pubsubChannel.start();
        return pubsubChannel;
    }
}

