/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.pubsub.queue.kekio.configuration;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.carp.framework.pubsub.annotation.PubsubListener;
import cn.sliew.carp.framework.pubsub.model.PubsubSubscriber;
import cn.sliew.carp.framework.pubsub.queue.kekio.QueuePubsubChannelFactory;
import cn.sliew.carp.framework.pubsub.queue.kekio.QueuePubsubSubscriber;
import cn.sliew.carp.framework.queue.kekio.MessageHandler;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class QueuePubsubListenerBootstrap
implements ApplicationRunner {
    @Autowired
    private QueuePubsubChannelFactory pubsubChannelFactory;

    public void run(ApplicationArguments args) throws Exception {
        Map beansWithAnnotation = SpringUtil.getApplicationContext().getBeansWithAnnotation(PubsubListener.class);
        for (Map.Entry entry : beansWithAnnotation.entrySet()) {
            PubsubListener ann;
            Object bean = entry.getValue();
            Class targetClass = AopUtils.getTargetClass(bean);
            if (!MessageHandler.class.isAssignableFrom(targetClass) || (ann = targetClass.getAnnotation(PubsubListener.class)) == null) continue;
            String queue = ann.queue();
            String group = ann.group();
            this.pubsubChannelFactory.get(queue).register((PubsubSubscriber)new QueuePubsubSubscriber(group, (MessageHandler)bean));
        }
    }
}

