/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.pubsub.model;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public abstract class AbstractLifecycle
implements SmartLifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLifecycle.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private ReentrantLock lifecycleLock = new ReentrantLock();

    public void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.isRunning()) {
                this.doStart();
                this.running.compareAndSet(false, true);
            }
        }
        catch (Exception e) {
            log.error("Start queue error", (Throwable)e);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected abstract void doStart() throws Exception;

    public void stop() {
        if (this.isRunning()) {
            this.lifecycleLock.lock();
            try {
                this.doStop();
                this.running.compareAndSet(true, false);
            }
            catch (Exception e) {
                log.error("Stop queue error", (Throwable)e);
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
    }

    protected abstract void doStop() throws Exception;

    public boolean isRunning() {
        return this.running.get();
    }
}

