/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.pf4j.spring;

import cn.sliew.carp.framework.pf4j.spring.BeanPromoter;
import cn.sliew.carp.framework.pf4j.spring.ExposeToApp;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.bind.annotation.RestController;

public class SpringLoaderBeanPostProcessor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringLoaderBeanPostProcessor.class);
    private final GenericApplicationContext pluginContext;
    private final BeanPromoter beanPromoter;

    public SpringLoaderBeanPostProcessor(GenericApplicationContext pluginContext, BeanPromoter beanPromoter) {
        this.pluginContext = pluginContext;
        this.beanPromoter = beanPromoter;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        try {
            BeanDefinition def = this.pluginContext.getBeanDefinition(beanName);
            boolean exposeToApp = false;
            if (bean.getClass().isAnnotationPresent(ExposeToApp.class) || bean.getClass().isAnnotationPresent(RestController.class)) {
                exposeToApp = true;
            } else if (def instanceof AnnotatedBeanDefinition) {
                AnnotationMetadata metadata = ((AnnotatedBeanDefinition)def).getMetadata();
                if (metadata.hasAnnotation(ExposeToApp.class.getName())) {
                    exposeToApp = true;
                } else {
                    Set methods = metadata.getAnnotatedMethods(ExposeToApp.class.getName());
                    if (methods.stream().anyMatch(method -> method.getMethodName().equals(beanName))) {
                        exposeToApp = true;
                    }
                }
            }
            if (exposeToApp) {
                Class<?> klass = bean.getClass();
                if (def.getBeanClassName() != null) {
                    klass = this.pluginContext.getClassLoader().loadClass(def.getBeanClassName());
                }
                log.debug("Adding bean {} to application context", (Object)beanName);
                this.beanPromoter.promote(beanName, bean, klass, def.isPrimary());
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading class for bean {}", (Object)beanName, (Object)e);
        }
        return bean;
    }
}

