/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.pf4j.spring;

import cn.sliew.carp.framework.pf4j.spring.BeanPromoter;
import cn.sliew.carp.framework.pf4j.spring.SpringLoaderBeanPostProcessor;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class SpringLoader
implements ApplicationContextAware {
    private final ClassLoader pluginClassLoader;
    private final List<String> packagesToScan;
    private final List<Class> classesToRegister;
    private final AnnotationConfigApplicationContext pluginContext;

    public SpringLoader(ClassLoader pluginClassLoader, List<String> packagesToScan, List<Class> classesToRegister, AnnotationConfigApplicationContext pluginContext) {
        this.pluginClassLoader = pluginClassLoader;
        this.packagesToScan = packagesToScan;
        this.classesToRegister = classesToRegister;
        this.pluginContext = pluginContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        final GenericApplicationContext appContext = (GenericApplicationContext)applicationContext;
        BeanPromoter beanPromoter = new BeanPromoter(){

            @Override
            public void promote(String beanName, Object bean, Class beanClass, boolean isPrimary) {
                appContext.registerBean(beanName, beanClass, () -> bean, new BeanDefinitionCustomizer[]{b -> {
                    if (isPrimary) {
                        b.setPrimary(true);
                    }
                }});
            }
        };
        this.pluginContext.setParent((ApplicationContext)appContext);
        this.pluginContext.setClassLoader(this.pluginClassLoader);
        ConfigurationClassPostProcessor configPostProcessor = new ConfigurationClassPostProcessor();
        configPostProcessor.setBeanClassLoader(this.pluginClassLoader);
        configPostProcessor.setEnvironment((Environment)appContext.getEnvironment());
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        resourceLoader.setClassLoader(this.pluginClassLoader);
        configPostProcessor.setResourceLoader((ResourceLoader)resourceLoader);
        this.pluginContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configPostProcessor);
        this.pluginContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new SpringLoaderBeanPostProcessor((GenericApplicationContext)this.pluginContext, beanPromoter));
        this.pluginContext.scan(this.packagesToScan.toArray(new String[this.packagesToScan.size()]));
        this.classesToRegister.forEach(klass -> this.pluginContext.register(new Class[]{klass}));
        this.pluginContext.refresh();
    }
}

