/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.sliew.carp.framework.pf4j.core.events;

import cn.sliew.carp.framework.pf4j.api.events.CarpEventListener;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;

/**
 * Creates an asynchronous {@link ApplicationListener}, delegating all implementation to {@link SpringEventListenerAdapter}.
 */
public class AsyncSpringEventListenerAdapter implements ApplicationListener<ApplicationEvent> {

    private final SpringEventListenerAdapter adapter;

    /**
     * Constructor.
     *
     * @param eventListener
     */
    public AsyncSpringEventListenerAdapter(CarpEventListener<?> eventListener) {
        this.adapter = new SpringEventListenerAdapter(eventListener);
    }

    @Async
    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        adapter.onApplicationEvent(event);
    }
}
