/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.mybatis.config;

import cn.sliew.carp.framework.common.security.CarpSecurityContext;
import cn.sliew.carp.framework.common.security.OnlineUserInfo;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.Date;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
public class CarpMybatisConfig {
    @Bean
    public MybatisPlusInterceptor carpPaginationInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    @Component
    public static class CarpMetaHandler
    implements MetaObjectHandler {
        public void insertFill(MetaObject metaObject) {
            String userName = this.getUserNameOrDefault();
            this.strictInsertFill(metaObject, "creator", () -> userName, String.class);
            this.strictInsertFill(metaObject, "createTime", () -> new Date(), Date.class);
            this.strictInsertFill(metaObject, "editor", () -> userName, String.class);
            this.strictInsertFill(metaObject, "updateTime", () -> new Date(), Date.class);
        }

        public void updateFill(MetaObject metaObject) {
            String userName = this.getUserNameOrDefault();
            this.strictUpdateFill(metaObject, "editor", () -> userName, String.class);
            this.strictUpdateFill(metaObject, "updateTime", () -> new Date(), Date.class);
        }

        private String getUserNameOrDefault() {
            OnlineUserInfo userInfo = CarpSecurityContext.get();
            if (userInfo != null) {
                return userInfo.getNickName();
            }
            return "sys";
        }
    }
}

