/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.lock.shedlock;

import cn.sliew.carp.framework.common.lock.LockAndRunExecutor;
import cn.sliew.carp.framework.common.lock.LockRunResult;
import cn.sliew.carp.framework.common.util.KeyUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShedLockLockAndRunExecutor
implements LockAndRunExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShedLockLockAndRunExecutor.class);
    private final LockProvider lockProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockRunResult<Void> execute(Runnable action, String keyName) {
        Optional<SimpleLock> lockOpt = this.getLock(keyName);
        if (lockOpt.isEmpty()) {
            log.error("Failed to acquire shedlock for key: {}", (Object)keyName);
            return new LockRunResult(false);
        }
        try {
            log.debug("Executing action with a lock for key: {}", (Object)keyName);
            action.run();
            log.debug("Finished action execution with a lock for key: {}", (Object)keyName);
            LockRunResult lockRunResult = new LockRunResult(true, true);
            return lockRunResult;
        }
        catch (Exception e) {
            log.error("An exception occurred while executing action with a lock for key: {}", (Object)keyName);
            LockRunResult lockRunResult = new LockRunResult(true, e);
            return lockRunResult;
        }
        finally {
            lockOpt.get().unlock();
            log.debug("Released shedlock for key {}", (Object)keyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> LockRunResult<R> execute(Callable<R> action, String keyName) {
        Optional<SimpleLock> lockOpt = this.getLock(keyName);
        if (lockOpt.isEmpty()) {
            log.error("Failed to acquire shedlock for key: {}", (Object)keyName);
            return new LockRunResult(false);
        }
        try {
            log.debug("Executing action with a lock for key: {}", (Object)keyName);
            R callableResult = action.call();
            log.debug("Finished action execution with a lock for key: {}", (Object)keyName);
            LockRunResult lockRunResult = new LockRunResult(true, true, callableResult);
            return lockRunResult;
        }
        catch (Exception e) {
            log.error("An exception occurred while executing action with a lock for key: {}", (Object)keyName);
            LockRunResult lockRunResult = new LockRunResult(true, e);
            return lockRunResult;
        }
        finally {
            lockOpt.get().unlock();
            log.debug("Released shedlock for key {}", (Object)keyName);
        }
    }

    private Optional<SimpleLock> getLock(String keyName) {
        String lockKey = KeyUtil.buildLockKey((String)keyName, (Object[])new Object[0]);
        try {
            log.debug("Attempt to acquire shedlock for key: {}, lock: {}", (Object)keyName, (Object)lockKey);
            LockConfiguration lockConfiguration = new LockConfiguration(Instant.now(), lockKey, Duration.ofSeconds(1L), Duration.ofMillis(200L));
            return this.lockProvider.lock(lockConfiguration);
        }
        catch (Exception e) {
            log.error("An exception occurred during an attempt to acquire shedlock for key: {}, lock: {}", new Object[]{keyName, lockKey, e});
            throw e;
        }
    }

    @Generated
    public ShedLockLockAndRunExecutor(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }
}

