/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.lock.shedlock;

import cn.sliew.carp.framework.common.lock.LockAndRunExecutor;
import cn.sliew.carp.framework.lock.shedlock.ShedLockLockAndRunExecutor;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@ConditionalOnMissingBean(value={LockAndRunExecutor.class})
@ConditionalOnProperty(value={"carp.framework.lock.shedlock.enabled"}, havingValue="true", matchIfMissing=false)
public class ShedLockExecutorAutoConfiguration {
    public static final String DATA_SOURCE_FACTORY = "cn.sliew.carp.lock.shedlock.DataSource";

    @Bean(value={"cn.sliew.carp.lock.shedlock.DataSource"})
    @ConfigurationProperties(prefix="spring.datasource.shedlock")
    public DataSource shedLockDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={LockProvider.class})
    public JdbcTemplateLockProvider jdbcTemplateLockProvider(@Qualifier(value="cn.sliew.carp.lock.shedlock.DataSource") DataSource shedLockDataSource) {
        return new JdbcTemplateLockProvider(JdbcTemplateLockProvider.Configuration.builder().withTableName("shedlock").withJdbcTemplate(new JdbcTemplate(shedLockDataSource)).usingDbTime().build());
    }

    @Bean
    public ShedLockLockAndRunExecutor shedLockLockAndRunExecutor(LockProvider lockProvider) {
        return new ShedLockLockAndRunExecutor(lockProvider);
    }
}

