/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.lock.redis;

import cn.sliew.carp.framework.common.lock.LockAndRunExecutor;
import cn.sliew.carp.framework.common.lock.LockRunResult;
import cn.sliew.carp.framework.redis.RedissonUtil;
import java.time.Duration;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLockAndRunExecutor
implements LockAndRunExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisLockAndRunExecutor.class);
    private final RedissonUtil redissonUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockRunResult<Void> execute(Runnable action, String keyName) {
        boolean locked = this.redissonUtil.lock(keyName, Duration.ofSeconds(1L));
        if (!locked) {
            log.error("Failed to acquire redis lock for key: {}", (Object)keyName);
            return new LockRunResult(false);
        }
        try {
            log.debug("Executing action with a redis lock for key: {}", (Object)keyName);
            action.run();
            log.debug("Finished action execution with a redis lock for key: {}", (Object)keyName);
            LockRunResult lockRunResult = new LockRunResult(true, true);
            return lockRunResult;
        }
        catch (Exception e) {
            log.error("An exception occurred while executing action with a redis lock for key: {}", (Object)keyName, (Object)e);
            LockRunResult lockRunResult = new LockRunResult(true, e);
            return lockRunResult;
        }
        finally {
            this.redissonUtil.unlock(keyName);
            log.debug("Released redis lock for key {}", (Object)keyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> LockRunResult<R> execute(Callable<R> action, String keyName) {
        boolean locked = this.redissonUtil.lock(keyName, Duration.ofSeconds(1L));
        if (!locked) {
            log.error("Failed to acquire redis lock for key: {}", (Object)keyName);
            return new LockRunResult(false);
        }
        try {
            log.debug("Executing action with a redis lock for key: {}", (Object)keyName);
            R callableResult = action.call();
            log.debug("Finished action execution with a redis lock for key: {}", (Object)keyName);
            LockRunResult lockRunResult = new LockRunResult(true, true, callableResult);
            return lockRunResult;
        }
        catch (Exception e) {
            log.error("An exception occurred while executing action with a redis lock for key: {}", (Object)keyName, (Object)e);
            LockRunResult lockRunResult = new LockRunResult(true, e);
            return lockRunResult;
        }
        finally {
            this.redissonUtil.unlock(keyName);
            log.debug("Released redis lock for key {}", (Object)keyName);
        }
    }

    @Generated
    public RedisLockAndRunExecutor(RedissonUtil redissonUtil) {
        this.redissonUtil = redissonUtil;
    }
}

