/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.kubernetes.resources;

import cn.sliew.carp.framework.kubernetes.resources.KubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;

public class AbstractKubernetesResource<T extends HasMetadata>
implements KubernetesResource<T> {
    private final KubernetesClient client;
    private final T origin;

    @Override
    public T getOrigin() {
        return this.origin;
    }

    @Override
    public Optional<T> get() {
        return Optional.ofNullable((HasMetadata)this.client.resource(this.origin).get());
    }

    @Override
    public T createOrGet(UnaryOperator<T> operator) {
        return (T)this.get().orElseGet(() -> {
            HasMetadata resource = (HasMetadata)operator.apply(this.origin);
            return (HasMetadata)this.client.resource(resource).createOrReplace();
        });
    }

    @Override
    public T patch(UnaryOperator<T> operator) {
        return (T)((HasMetadata)this.client.resource(this.origin).patch((Object)((HasMetadata)operator.apply(this.origin))));
    }

    @Override
    public boolean delete() {
        this.client.resource(this.origin).delete();
        return true;
    }

    @ConstructorProperties(value={"client", "origin"})
    @Generated
    public AbstractKubernetesResource(KubernetesClient client, T origin) {
        this.client = client;
        this.origin = origin;
    }
}

