/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery.internal;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.Done;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.DispatcherSelector$;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$MessageSent$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$State$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$DurableQueueTerminated$;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$DeferredBehavior$;
import org.apache.pekko.actor.typed.receptionist.Receptionist;
import org.apache.pekko.actor.typed.receptionist.Receptionist$Subscribe$;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.LineNumbers$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;

@InternalApi
public final class WorkPullingProducerControllerImpl$ {
    public static WorkPullingProducerControllerImpl$ MODULE$;

    static {
        new WorkPullingProducerControllerImpl$();
    }

    /*
     * WARNING - void declaration
     */
    public <A> Behavior<WorkPullingProducerController.Command<A>> apply(String producerId, ServiceKey<ConsumerController.Command<A>> workerServiceKey, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, WorkPullingProducerController.Settings settings, ClassTag<A> evidence$1) {
        void withStash_factory;
        void withStash_capacity;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)stashBuffer -> {
            void setup_factory;
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)context -> {
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producerId"), (Object)producerId)}));
                context.setLoggerName("org.apache.pekko.actor.typed.delivery.WorkPullingProducerController");
                ActorRef<Receptionist.Listing> listingAdapter = context.messageAdapter((Function1 & Serializable & scala.Serializable)listing -> new WorkPullingProducerControllerImpl.CurrentWorkers(listing.allServiceInstances(workerServiceKey)), ClassTag$.MODULE$.apply(Receptionist.Listing.class));
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(context.system().receptionist()), Receptionist$Subscribe$.MODULE$.apply(workerServiceKey, listingAdapter));
                Option durableQueue = MODULE$.askLoadState((ActorContext<WorkPullingProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
                return Behaviors$.MODULE$.withMdc((Map<String, String>)map, MODULE$.waitingForStart(producerId, (ActorContext<WorkPullingProducerControllerImpl.InternalCommand>)context, (StashBuffer<WorkPullingProducerControllerImpl.InternalCommand>)stashBuffer, durableQueue, settings, (Option)None$.MODULE$, MODULE$.createInitialState(durableQueue.nonEmpty()), evidence$1), ClassTag$.MODULE$.apply(WorkPullingProducerControllerImpl.InternalCommand.class));
            };
            if (Behaviors$.MODULE$ == null) {
                throw null;
            }
            if (BehaviorImpl$DeferredBehavior$.MODULE$ == null) {
                throw null;
            }
            return new BehaviorImpl.DeferredBehavior<T>((Function1)setup_factory){
                private final Function1 factory$1;

                public Behavior<T> apply(TypedActorContext<T> ctx) {
                    return (Behavior)this.factory$1.apply(ctx.asScala());
                }

                public String toString() {
                    return new StringBuilder(10).append("Deferred(").append(LineNumbers$.MODULE$.apply((Object)this.factory$1)).append(")").toString();
                }
                {
                    this.factory$1 = factory$1;
                }
            };
        };
        int n = settings.bufferSize();
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        Function1 & Serializable & scala.Serializable withStash_setup_factory = arg_0 -> Behaviors$.$anonfun$withStash$1((int)withStash_capacity, (Function1)withStash_factory, arg_0);
        if (BehaviorImpl$DeferredBehavior$.MODULE$ == null) {
            throw null;
        }
        return new /* invalid duplicate definition of identical inner class */.narrow();
    }

    private <A> Option<DurableProducerQueue.State<A>> createInitialState(boolean hasDurableQueue) {
        if (hasDurableQueue) {
            return None$.MODULE$;
        }
        return new Some(DurableProducerQueue$State$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    private <A> Behavior<WorkPullingProducerControllerImpl.InternalCommand> waitingForStart(String producerId, ActorContext<WorkPullingProducerControllerImpl.InternalCommand> context, StashBuffer<WorkPullingProducerControllerImpl.InternalCommand> stashBuffer, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, WorkPullingProducerController.Settings settings, Option<ActorRef<WorkPullingProducerController.RequestNext<A>>> producer, Option<DurableProducerQueue.State<A>> initialState, ClassTag<A> evidence$2) {
        void receiveMessage_onMessage;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof WorkPullingProducerController.Start) {
                WorkPullingProducerController.Start start = (WorkPullingProducerController.Start)x0$1;
                ProducerControllerImpl$.MODULE$.enforceLocalProducer(start.producer());
                if (initialState instanceof Some) {
                    DurableProducerQueue.State s = (DurableProducerQueue.State)((Some)initialState).value();
                    return this.becomeActive$1(start.producer(), s, context, evidence$2, stashBuffer, producerId, durableQueue, settings);
                }
                if (None$.MODULE$.equals(initialState)) {
                    return MODULE$.waitingForStart(producerId, context, stashBuffer, durableQueue, settings, (Option)new Some(start.producer()), initialState, evidence$2);
                }
                throw new MatchError((Object)initialState);
            }
            if (x0$1 instanceof WorkPullingProducerControllerImpl.LoadStateReply) {
                WorkPullingProducerControllerImpl.LoadStateReply loadStateReply = (WorkPullingProducerControllerImpl.LoadStateReply)x0$1;
                if (producer instanceof Some) {
                    ActorRef p = (ActorRef)((Some)producer).value();
                    return this.becomeActive$1(p, loadStateReply.state(), context, evidence$2, stashBuffer, producerId, durableQueue, settings);
                }
                if (None$.MODULE$.equals(producer)) {
                    return MODULE$.waitingForStart(producerId, context, stashBuffer, durableQueue, settings, producer, (Option)new Some(loadStateReply.state()), evidence$2);
                }
                throw new MatchError((Object)producer);
            }
            if (x0$1 instanceof WorkPullingProducerControllerImpl.LoadStateFailed) {
                int attempt = ((WorkPullingProducerControllerImpl.LoadStateFailed)x0$1).attempt();
                if (attempt >= settings.producerControllerSettings().durableQueueRetryAttempts()) {
                    String errorMessage = new StringBuilder(46).append("LoadState failed after [").append(attempt).append("] attempts, giving up.").toString();
                    context.log().error(errorMessage);
                    throw new TimeoutException(errorMessage);
                }
                context.log().warn("LoadState failed, attempt [{}] of [{}], retrying.", (Object)BoxesRunTime.boxToInteger((int)attempt), (Object)BoxesRunTime.boxToInteger((int)settings.producerControllerSettings().durableQueueRetryAttempts()));
                MODULE$.askLoadState(context, durableQueue, settings, attempt + 1);
                return Behaviors$.MODULE$.same();
            }
            if (WorkPullingProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(x0$1)) {
                throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
            }
            MODULE$.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$checkStashFull(stashBuffer);
            stashBuffer.stash((WorkPullingProducerControllerImpl.InternalCommand)x0$1);
            return Behaviors$.MODULE$.same();
        };
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        return new Behaviors.ReceiveMessageImpl<WorkPullingProducerControllerImpl.InternalCommand>((Function1<WorkPullingProducerControllerImpl.InternalCommand, Behavior<WorkPullingProducerControllerImpl.InternalCommand>>)receiveMessage_onMessage);
    }

    public <A> void org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$checkStashFull(StashBuffer<WorkPullingProducerControllerImpl.InternalCommand> stashBuffer) {
        if (stashBuffer.isFull()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Buffer is full, size [").append(stashBuffer.size()).append("].").toString());
        }
    }

    private <A> Option<ActorRef<DurableProducerQueue.Command<A>>> askLoadState(ActorContext<WorkPullingProducerControllerImpl.InternalCommand> context, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, WorkPullingProducerController.Settings settings) {
        return durableQueueBehavior.map((Function1 & Serializable & scala.Serializable)b -> {
            ActorRef ref = context.spawn(b, "durable", DispatcherSelector$.MODULE$.sameAsParent());
            context.watchWith(ref, WorkPullingProducerControllerImpl$DurableQueueTerminated$.MODULE$);
            MODULE$.askLoadState(context, (Option)new Some(ref), settings, 1);
            return ref;
        });
    }

    private <A> void askLoadState(ActorContext<WorkPullingProducerControllerImpl.InternalCommand> context, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, WorkPullingProducerController.Settings settings, int attempt) {
        Timeout loadTimeout = Timeout$.MODULE$.durationToTimeout(settings.producerControllerSettings().durableQueueRequestTimeout());
        durableQueue.foreach((Function1 & Serializable & scala.Serializable)ref -> {
            context.ask(ref, (Function1 & Serializable & scala.Serializable)askReplyTo -> new DurableProducerQueue.LoadState(askReplyTo), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 instanceof Success) {
                    DurableProducerQueue.State s = (DurableProducerQueue.State)((Success)x0$1).value();
                    return new WorkPullingProducerControllerImpl.LoadStateReply(s);
                }
                if (x0$1 instanceof Failure) {
                    return new WorkPullingProducerControllerImpl.LoadStateFailed(attempt$1);
                }
                throw new MatchError(x0$1);
            }, loadTimeout, ClassTag$.MODULE$.apply(DurableProducerQueue.State.class));
            return BoxedUnit.UNIT;
        });
    }

    private <A> WorkPullingProducerControllerImpl.State<A> createInitialState(long currentSeqNr, ActorRef<WorkPullingProducerController.RequestNext<A>> producer) {
        return new WorkPullingProducerControllerImpl.State<A>(currentSeqNr, Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Map().empty(), (Map<Object, WorkPullingProducerControllerImpl.PreselectedWorker>)Predef$.MODULE$.Map().empty(), (Map<Object, ActorRef<Done>>)Predef$.MODULE$.Map().empty(), (Map<Object, WorkPullingProducerControllerImpl.HandOver>)Predef$.MODULE$.Map().empty(), producer, false);
    }

    public static final /* synthetic */ void $anonfun$waitingForStart$1(ActorContext context$1, DurableProducerQueue.MessageSent x0$1) {
        Option<Tuple5<Object, Object, Object, String, Object>> option = DurableProducerQueue$MessageSent$.MODULE$.unapply(x0$1);
        if (!option.isEmpty()) {
            long oldSeqNr = BoxesRunTime.unboxToLong((Object)((Tuple5)option.get())._1());
            Object msg = ((Tuple5)option.get())._2();
            String oldConfirmationQualifier = (String)((Tuple5)option.get())._4();
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(context$1.self()), new WorkPullingProducerControllerImpl.ResendDurableMsg<Object>(msg, oldConfirmationQualifier, oldSeqNr));
            return;
        }
    }

    private final Behavior becomeActive$1(ActorRef p, DurableProducerQueue.State s, ActorContext context$1, ClassTag evidence$2$1, StashBuffer stashBuffer$2, String producerId$2, Option durableQueue$1, WorkPullingProducerController.Settings settings$2) {
        s.unconfirmed().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkPullingProducerControllerImpl$.$anonfun$waitingForStart$1(context$1, x0$1);
            return BoxedUnit.UNIT;
        });
        ActorRef msgAdapter = context$1.messageAdapter((Function1 & Serializable & scala.Serializable)msg -> new WorkPullingProducerControllerImpl.Msg<Object>(msg, false, (Option<ActorRef<Done>>)None$.MODULE$), evidence$2$1);
        WorkPullingProducerController.RequestNext requestNext = new WorkPullingProducerController.RequestNext(msgAdapter, context$1.self());
        Behavior<WorkPullingProducerControllerImpl.InternalCommand> b = new WorkPullingProducerControllerImpl(context$1, stashBuffer$2, producerId$2, requestNext, durableQueue$1, settings$2, evidence$2$1).org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(this.createInitialState(s.currentSeqNr(), p));
        return stashBuffer$2.unstashAll(b);
    }

    private WorkPullingProducerControllerImpl$() {
        MODULE$ = this;
    }
}

