/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.primitives;

import cn.sliew.milky.common.primitives.Strings;

public final class Booleans {
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    private Booleans() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static boolean isBoolean(char[] text, int offset, int length) {
        if (text == null || length == 0) {
            return false;
        }
        return Booleans.isBoolean(new String(text, offset, length));
    }

    public static boolean isBoolean(String value) {
        return Booleans.isFalse(value) || Booleans.isTrue(value);
    }

    public static boolean isFalse(String value) {
        return FALSE.equals(value);
    }

    public static boolean isTrue(String value) {
        return TRUE.equals(value);
    }

    public static boolean parseBoolean(char[] text, int offset, int length, boolean defaultValue) {
        if (text == null || length == 0) {
            return defaultValue;
        }
        return Booleans.parseBoolean(new String(text, offset, length));
    }

    public static boolean parseBoolean(String value) {
        if (Booleans.isFalse(value)) {
            return false;
        }
        if (Booleans.isTrue(value)) {
            return true;
        }
        throw new IllegalArgumentException("Failed to parse value [" + value + "] as only [true] or [false] are allowed.");
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (Strings.hasText(value)) {
            return Booleans.parseBoolean(value);
        }
        return defaultValue;
    }

    public static Boolean parseBoolean(String value, Boolean defaultValue) {
        if (Strings.hasText(value)) {
            return Booleans.parseBoolean(value);
        }
        return defaultValue;
    }
}

