/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.model;

import cn.sliew.carp.framework.common.enums.ErrorShowTypeEnum;
import cn.sliew.carp.framework.common.enums.ResponseCodeEnum;
import cn.sliew.milky.common.util.JacksonUtil;
import lombok.Generated;

public class ResponseVO<T> {
    private Boolean success;
    private T data;
    private String errorCode;
    private String errorMessage;
    private Integer showType;

    private ResponseVO() {
    }

    public static ResponseVO success() {
        ResponseVO info = new ResponseVO();
        info.setSuccess(true);
        return info;
    }

    public static ResponseVO success(Object data) {
        ResponseVO<Object> info = new ResponseVO<Object>();
        info.setSuccess(true);
        info.setData(data);
        return info;
    }

    public static ResponseVO error(String message) {
        ResponseVO info = new ResponseVO();
        info.setSuccess(false);
        info.setErrorCode(ResponseCodeEnum.ERROR.getCode());
        info.setErrorMessage(message);
        info.setShowType(ErrorShowTypeEnum.NOTIFICATION.getCode());
        return info;
    }

    public static ResponseVO error(ResponseCodeEnum info) {
        return ResponseVO.error(info.getCode(), info.getValue());
    }

    public static ResponseVO error(String code, String message) {
        ResponseVO info = new ResponseVO();
        info.setSuccess(false);
        info.setErrorCode(code);
        info.setErrorMessage(message);
        info.setShowType(ErrorShowTypeEnum.NOTIFICATION.getCode());
        return info;
    }

    public static ResponseVO error(String code, String message, ErrorShowTypeEnum showType) {
        ResponseVO info = new ResponseVO();
        info.setSuccess(false);
        info.setErrorCode(code);
        info.setErrorMessage(message);
        info.setShowType(showType.getCode());
        return info;
    }

    public String toString() {
        return JacksonUtil.toJsonString((Object)this);
    }

    @Generated
    public Boolean getSuccess() {
        return this.success;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Integer getShowType() {
        return this.showType;
    }

    @Generated
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setShowType(Integer showType) {
        this.showType = showType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseVO)) {
            return false;
        }
        ResponseVO other = (ResponseVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Integer this$showType = this.getShowType();
        Integer other$showType = other.getShowType();
        if (this$showType == null ? other$showType != null : !((Object)this$showType).equals(other$showType)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResponseVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Integer $showType = this.getShowType();
        result = result * 59 + ($showType == null ? 43 : ((Object)$showType).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }
}

