/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer;
import org.apache.pekko.serialization.NullSerializer$;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationSetup;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerDetails;
import org.apache.pekko.serialization.SerializerDetails$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011ev!B.]\u0011\u0003)g!B4]\u0011\u0003A\u0007\"B8\u0002\t\u0003\u0001X\u0001B9\u0002\u0001ID!\"a\b\u0002\u0005\u0004%\tAXA\u0011\u0011!\ti.\u0001Q\u0001\n\u0005\rbABAv\u0003\u0001\ti\u000f\u0003\u0006\u0002p\u001a\u0011)\u0019!C\u0001\u0003cD!B!\u0002\u0007\u0005\u0003\u0005\u000b\u0011BAz\u0011\u0019yg\u0001\"\u0001\u0003\b!I!Q\u0002\u0004C\u0002\u0013\u0005!q\u0002\u0005\t\u000571\u0001\u0015!\u0003\u0003\u0012!I!Q\u0004\u0004C\u0002\u0013\u0005!q\u0002\u0005\t\u0005?1\u0001\u0015!\u0003\u0003\u0012!9!\u0011\u0005\u0004\u0005\u000e\t\r\u0002b\u0002B\u0015\u0003\u0011\u0005!1\u0006\u0004\u0007\u0003g\t!)!\u000e\t\u0015\u0005\r\u0003C!f\u0001\n\u0003\t)\u0005\u0003\u0006\u0002TA\u0011\t\u0012)A\u0005\u0003\u000fB!\"!\u0016\u0011\u0005+\u0007I\u0011AA,\u0011)\ty\u0006\u0005B\tB\u0003%\u0011\u0011\f\u0005\u0007_B!\t!!\u0019\t\u0013\u0005\u001d\u0004#!A\u0005\u0002\u0005%\u0004\"CA8!E\u0005I\u0011AA9\u0011%\t9\tEI\u0001\n\u0003\tI\tC\u0005\u0002\u000eB\t\t\u0011\"\u0011\u0002\u0010\"I\u0011\u0011\u0015\t\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003W\u0003\u0012\u0011!C\u0001\u0003[C\u0011\"a-\u0011\u0003\u0003%\t%!.\t\u0013\u0005\r\u0007#!A\u0005\u0002\u0005\u0015\u0007\"CAh!\u0005\u0005I\u0011IAi\u0011%\t\u0019\u000eEA\u0001\n\u0003\n)\u000eC\u0005\u0002XB\t\t\u0011\"\u0011\u0002Z\u001eI!qG\u0001\u0002\u0002#\u0005!\u0011\b\u0004\n\u0003g\t\u0011\u0011!E\u0001\u0005wAaa\u001c\u0012\u0005\u0002\t%\u0003\"CAjE\u0005\u0005IQIAk\u0011%\u0011YEIA\u0001\n\u0003\u0013i\u0005C\u0005\u0003T\t\n\t\u0011\"!\u0003V!I!1\r\u0012\u0002\u0002\u0013%!Q\r\u0005\b\u0005[\nA\u0011\u0001B8\u0011\u001d\u0011i)\u0001C\u0001\u0005\u001f3Qa\u001a/\u0001\u0005#C!\"!\u0016+\u0005\u000b\u0007I\u0011\u0001BM\u0011)\tyF\u000bB\u0001B\u0003%!q\u0011\u0005\u0007_*\"\tAa'\t\u0013\t\u0005&F1A\u0005\u0002\t\r\u0006\u0002\u0003BUU\u0001\u0006IA!*\t\u0013\t-&F1A\u0005\u0002\t5\u0006\u0002\u0003BXU\u0001\u0006I!a2\t\u0011\tE&\u0006)A\u0005\u0005gC\u0011Ba0+\u0005\u0004%\tA!1\t\u0011\t%'\u0006)A\u0005\u0005\u0007D\u0011Ba3+\u0005\u0004%IA!4\t\u0011\te(\u0006)A\u0005\u0005\u001fD\u0001Ba?+\t\u0003q&Q \u0005\b\u0005[RC\u0011BB\u0002\u0011\u001d\u0019yA\u000bC\u0001\u0007#Aqa!\u000b+\t\u0003\u0019Y\u0003C\u0004\u0004*)\"\taa\u001c\t\u000f\rm$\u0006\"\u0003\u0004~!91q\u0011\u0016\u0005\u0002\r%\u0005bBB\u0015U\u0011\u00051Q\u0017\u0005\b\u0007\u000bTC\u0011ABd\u0011\u001d\u0019YM\u000bC\u0001\u0007\u001bDqa!8+\t\u0003\u0019y\u000eC\u0004\u0004^*\"Iaa:\t\u0013\r=(F1A\u0005\n\rE\b\u0002CB\u0000U\u0001\u0006Iaa=\t\u0013\u0011\u0005!F1A\u0005\n\u0011\r\u0001\u0002\u0003C\u0004U\u0001\u0006I\u0001\"\u0002\t\u0015\u0011%!F1A\u0005\u0002y#Y\u0001\u0003\u0005\u0005\u0012)\u0002\u000b\u0011\u0002C\u0007\u0011\u001d!\u0019B\u000bC\u0005\t+Aq\u0001\"\r+\t\u0013!\u0019\u0004C\u0004\u0005F)\"I\u0001b\u0012\t\u000f\u00115#\u0006\"\u0003\u0005P!9Aq\u000b\u0016\u0005\n\u0011e\u0003\"\u0003C3U\t\u0007I\u0011\u0002C4\u0011!!YH\u000bQ\u0001\n\u0011%\u0004\"\u0003C?U\t\u0007I\u0011\u0001C@\u0011!!\u0019I\u000bQ\u0001\n\u0011\u0005\u0005\"\u0003CCU\t\u0007I\u0011\u0002CD\u0011!!YI\u000bQ\u0001\n\u0011%\u0005b\u0002CGU\u0011%Aq\u0012\u0005\n\t+S#\u0019!C\u0005\u0005[C\u0001\u0002b&+A\u0003%\u0011q\u0019\u0005\n\t3S#\u0019!C\u0005\u0005[C\u0001\u0002b'+A\u0003%\u0011q\u0019\u0005\b\t;SC\u0011\u0002CP\u0011!!\u0019K\u000bC\u0001=\u0012\u0015\u0016!D*fe&\fG.\u001b>bi&|gN\u0003\u0002^=\u0006i1/\u001a:jC2L'0\u0019;j_:T!a\u00181\u0002\u000bA,7n[8\u000b\u0005\u0005\u0014\u0017AB1qC\u000eDWMC\u0001d\u0003\ry'oZ\u0002\u0001!\t1\u0017!D\u0001]\u00055\u0019VM]5bY&T\u0018\r^5p]N\u0011\u0011!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0002Y\u0006)1oY1mC&\u0011an\u001b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)'aD\"mCN\u001c8+\u001a:jC2L'0\u001a:\u0011\u000b)\u001cX/!\u0007\n\u0005Q\\'A\u0002+va2,'\u0007M\u0002w\u0003\u000f\u0001Ba\u001e@\u0002\u00049\u0011\u0001\u0010 \t\u0003s.l\u0011A\u001f\u0006\u0003w\u0012\fa\u0001\u0010:p_Rt\u0014BA?l\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\u000b\rc\u0017m]:\u000b\u0005u\\\u0007\u0003BA\u0003\u0003\u000fa\u0001\u0001B\u0006\u0002\n\r\t\t\u0011!A\u0003\u0002\u0005-!aA0%cE!\u0011QBA\n!\rQ\u0017qB\u0005\u0004\u0003#Y'a\u0002(pi\"Lgn\u001a\t\u0004U\u0006U\u0011bAA\fW\n\u0019\u0011I\\=\u0011\u0007\u0019\fY\"C\u0002\u0002\u001eq\u0013!bU3sS\u0006d\u0017N_3s\u0003m\u0019WO\u001d:f]R$&/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]V\u0011\u00111\u0005\t\u0007\u0003K\tY#a\f\u000e\u0005\u0005\u001d\"bAA\u0015W\u0006!Q\u000f^5m\u0013\u0011\ti#a\n\u0003\u001f\u0011Kh.Y7jGZ\u000b'/[1cY\u0016\u00042!!\r\u0011\u001b\u0005\t!aC%oM>\u0014X.\u0019;j_:\u001cb\u0001E5\u00028\u0005u\u0002c\u00016\u0002:%\u0019\u00111H6\u0003\u000fA\u0013x\u000eZ;diB\u0019!.a\u0010\n\u0007\u0005\u00053N\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004bI\u0012\u0014Xm]:\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055c,A\u0003bGR|'/\u0003\u0003\u0002R\u0005-#aB!eIJ,7o]\u0001\tC\u0012$'/Z:tA\u000511/_:uK6,\"!!\u0017\u0011\t\u0005%\u00131L\u0005\u0005\u0003;\nYEA\u0006BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000e\t\u000b\u0007\u0003_\t\u0019'!\u001a\t\u000f\u0005\rS\u00031\u0001\u0002H!9\u0011QK\u000bA\u0002\u0005e\u0013\u0001B2paf$b!a\f\u0002l\u00055\u0004\"CA\"-A\u0005\t\u0019AA$\u0011%\t)F\u0006I\u0001\u0002\u0004\tI&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M$\u0006BA$\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003[\u0017AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYI\u000b\u0003\u0002Z\u0005U\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0012B!\u00111SAO\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015\u0001\u00027b]\u001eT!!a'\u0002\t)\fg/Y\u0005\u0005\u0003?\u000b)J\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003K\u00032A[AT\u0013\r\tIk\u001b\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003'\ty\u000bC\u0005\u00022n\t\t\u00111\u0001\u0002&\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a.\u0011\r\u0005e\u0016qXA\n\u001b\t\tYLC\u0002\u0002>.\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t-a/\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\fi\rE\u0002k\u0003\u0013L1!a3l\u0005\u001d\u0011un\u001c7fC:D\u0011\"!-\u001e\u0003\u0003\u0005\r!a\u0005\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!%\u0002\r\u0015\fX/\u00197t)\u0011\t9-a7\t\u0013\u0005E\u0006%!AA\u0002\u0005M\u0011\u0001H2veJ,g\u000e\u001e+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g\u000e\t\u0015\u0004\u000b\u0005\u0005\b\u0003BAr\u0003Ol!!!:\u000b\u0007\u0005\u0005e,\u0003\u0003\u0002j\u0006\u0015(aC%oi\u0016\u0014h.\u00197Ba&\u0014\u0001bU3ui&twm]\n\u0003\r%\faaY8oM&<WCAAz!\u0011\t)P!\u0001\u000e\u0005\u0005](\u0002BAx\u0003sTA!a?\u0002~\u0006AA/\u001f9fg\u00064WM\u0003\u0002\u0002\u0000\u0006\u00191m\\7\n\t\t\r\u0011q\u001f\u0002\u0007\u0007>tg-[4\u0002\u000f\r|gNZ5hAQ!!\u0011\u0002B\u0006!\r\t\tD\u0002\u0005\b\u0003_L\u0001\u0019AAz\u0003-\u0019VM]5bY&TXM]:\u0016\u0005\tE\u0001cB<\u0003\u0014\t]!qC\u0005\u0005\u0005+\t\tAA\u0002NCB\u00042a\u001eB\r\u0013\u0011\ty*!\u0001\u0002\u0019M+'/[1mSj,'o\u001d\u0011\u0002+M+'/[1mSj\fG/[8o\u0005&tG-\u001b8hg\u000612+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b%A\u0006d_:4\u0017n\u001a+p\u001b\u0006\u0004H\u0003\u0002B\t\u0005KAqAa\n\u000f\u0001\u0004\t\u00190A\u0002dM\u001e\f1c]3sS\u0006d\u0017N_3e\u0003\u000e$xN\u001d)bi\"$BAa\u0006\u0003.!9!qF\bA\u0002\tE\u0012\u0001C1di>\u0014(+\u001a4\u0011\t\u0005%#1G\u0005\u0005\u0005k\tYE\u0001\u0005BGR|'OU3g\u0003-IeNZ8s[\u0006$\u0018n\u001c8\u0011\u0007\u0005E\"eE\u0003#\u0005{\ti\u0004\u0005\u0006\u0003@\t\u0015\u0013qIA-\u0003_i!A!\u0011\u000b\u0007\t\r3.A\u0004sk:$\u0018.\\3\n\t\t\u001d#\u0011\t\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B\u001d\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tyCa\u0014\u0003R!9\u00111I\u0013A\u0002\u0005\u001d\u0003bBA+K\u0001\u0007\u0011\u0011L\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Fa\u0018\u0011\u000b)\u0014IF!\u0018\n\u0007\tm3N\u0001\u0004PaRLwN\u001c\t\u0007UN\f9%!\u0017\t\u0013\t\u0005d%!AA\u0002\u0005=\u0012a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u0007\u0005\u0003\u0002\u0014\n%\u0014\u0002\u0002B6\u0003+\u0013aa\u00142kK\u000e$\u0018\u0001G<ji\"$&/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]V!!\u0011\u000fB<)\u0011\u0011\u0019H!\"\u0015\t\tU$1\u0010\t\u0005\u0003\u000b\u00119\bB\u0004\u0003z!\u0012\r!a\u0003\u0003\u0003QCqA! )\u0001\u0004\u0011y(A\u0001g!\u0015Q'\u0011\u0011B;\u0013\r\u0011\u0019i\u001b\u0002\n\rVt7\r^5p]BBq!!\u0016)\u0001\u0004\u00119\t\u0005\u0003\u0002J\t%\u0015\u0002\u0002BF\u0003\u0017\u00121#\u0012=uK:$W\rZ!di>\u00148+_:uK6\fadZ3u\u0007V\u0014(/\u001a8u)J\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8\u0015\u0005\u0005=2\u0003\u0002\u0016j\u0005'\u0003B!!\u0013\u0003\u0016&!!qSA&\u0005%)\u0005\u0010^3og&|g.\u0006\u0002\u0003\bR!!Q\u0014BP!\t1'\u0006C\u0004\u0002V5\u0002\rAa\"\u0002\u0011M,G\u000f^5oON,\"A!*\u0011\u0007\t\u001dfA\u0004\u0002g\u0001\u0005I1/\u001a;uS:<7\u000fI\u0001\u0017\u00032dwn\u001e&bm\u0006\u001cVM]5bY&T\u0018\r^5p]V\u0011\u0011qY\u0001\u0018\u00032dwn\u001e&bm\u0006\u001cVM]5bY&T\u0018\r^5p]\u0002\nAa\u00187pOB!!Q\u0017B^\u001b\t\u00119LC\u0002\u0003:z\u000bQ!\u001a<f]RLAA!0\u00038\n!R*\u0019:lKJdunZ4j]\u001e\fE-\u00199uKJ\f1\u0001\\8h+\t\u0011\u0019\r\u0005\u0003\u00036\n\u0015\u0017\u0002\u0002Bd\u0005o\u0013a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013!D7b]&4Wm\u001d;DC\u000eDW-\u0006\u0002\u0003PB1!\u0011\u001bBo\u0005Cl!Aa5\u000b\t\tU'q[\u0001\u0007CR|W.[2\u000b\t\te'1\\\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0015\u00033KAAa8\u0003T\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0005\u0003d\n%(q\u0003Bv\u001b\t\u0011)O\u0003\u0003\u0003h\u0006m\u0016!C5n[V$\u0018M\u00197f\u0013\u0011\u0011)B!:\u0011\u000b)\u0014IF!<1\t\t=(Q\u001f\t\u0007\u0003'\u0013\tPa=\n\u0007}\f)\n\u0005\u0003\u0002\u0006\tUHa\u0003B|m\u0005\u0005\t\u0011!B\u0001\u0003\u0017\u00111a\u0018\u00133\u00039i\u0017M\\5gKN$8)Y2iK\u0002\n\u0001d]3sS\u0006d\u0017N_1uS>t\u0017J\u001c4pe6\fG/[8o+\t\u0011y\u0010E\u0002\u0003(BA3aNAq+\u0011\u0019)a!\u0003\u0015\t\r\u001d11\u0002\t\u0005\u0003\u000b\u0019I\u0001B\u0004\u0003za\u0012\r!a\u0003\t\u000f\tu\u0004\b1\u0001\u0004\u000eA)!N!!\u0004\b\u0005I1/\u001a:jC2L'0\u001a\u000b\u0005\u0007'\u0019)\u0003\u0005\u0004\u0002&\rU1\u0011D\u0005\u0005\u0007/\t9CA\u0002Uef\u0004RA[B\u000e\u0007?I1a!\bl\u0005\u0015\t%O]1z!\rQ7\u0011E\u0005\u0004\u0007GY'\u0001\u0002\"zi\u0016Daaa\n:\u0001\u0004I\u0017!A8\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u0005\u0007[\u0019\u0019\u0004\u0006\u0005\u00040\rU2\u0011HB\u001f!\u0019\t)c!\u0006\u00042A!\u0011QAB\u001a\t\u001d\u0011IH\u000fb\u0001\u0003\u0017Aqaa\u000e;\u0001\u0004\u0019I\"A\u0003csR,7\u000fC\u0004\u0004<i\u0002\r!!*\u0002\u0019M,'/[1mSj,'/\u00133\t\u000f\r}\"\b1\u0001\u0004B\u0005)1\r\\1{uB)!N!\u0017\u0004DA\"1QIB%!\u00119hpa\u0012\u0011\t\u0005\u00151\u0011\n\u0003\r\u0007\u0017\u001ai%!A\u0001\u0002\u000b\u00051Q\f\u0002\u0004?\u0012\"\u0004bBB u\u0001\u00071q\n\t\u0006U\ne3\u0011\u000b\u0019\u0005\u0007'\u001a9\u0006\u0005\u0003x}\u000eU\u0003\u0003BA\u0003\u0007/\"Aba\u0013\u0004N\u0005\u0005\t\u0011!B\u0001\u00073\nB!!\u0004\u0004\\A!\u0011QAB\u001a#\u0011\tia!\r)\u000fi\u001a\tga\u001a\u0004lA\u0019!na\u0019\n\u0007\r\u00154N\u0001\u0006eKB\u0014XmY1uK\u0012\f#a!\u001b\u0002yU\u001bX\r\t3fg\u0016\u0014\u0018.\u00197ju\u0016\u0004C\u000f[1uA\u0005\u001c7-\u001a9ug\u0002\"\b.\u001a\u0011a[\u0006t\u0017NZ3ti\u0002\u0004\u0013m\u001d\u0011bA\rd\u0017m]:!]\u0006lWML\u0011\u0003\u0007[\n!\"Q6lC\u0002\u0012dF\u000e\u00181)!\u0019\tha\u001d\u0004v\r]\u0004#BA\u0013\u0007+I\u0007bBB\u001cw\u0001\u00071\u0011\u0004\u0005\b\u0007wY\u0004\u0019AAS\u0011\u001d\u0019Ih\u000fa\u0001\u0005/\t\u0001\"\\1oS\u001a,7\u000f^\u0001\u0015I\u0016\u001cXM]5bY&TXMQ=uK\u0006\u0013(/Y=\u0015\u000f%\u001cyh!!\u0004\u0006\"91q\u0007\u001fA\u0002\re\u0001bBBBy\u0001\u0007\u0011\u0011D\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bbBB=y\u0001\u0007!qC\u0001\u0016I\u0016\u001cXM]5bY&TXMQ=uK\n+hMZ3s)\u001dI71RBN\u0007;Cqa!$>\u0001\u0004\u0019y)A\u0002ck\u001a\u0004Ba!%\u0004\u00186\u001111\u0013\u0006\u0005\u0007+\u000bI*A\u0002oS>LAa!'\u0004\u0014\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\rmR\b1\u0001\u0002&\"91\u0011P\u001fA\u0002\t]\u0001&B\u001f\u0004\"\u000eM\u0006#\u00026\u0004$\u000e\u001d\u0016bABSW\n1A\u000f\u001b:poN\u0004Ba!+\u000406\u001111\u0016\u0006\u0005\u0007[\u000bI*\u0001\u0002j_&!1\u0011WBV\u0005aqu\u000e^*fe&\fG.\u001b>bE2,W\t_2faRLwN\\\u0012\u0003\u0007O+Baa.\u0004>R11\u0011XB`\u0007\u0003\u0004b!!\n\u0004\u0016\rm\u0006\u0003BA\u0003\u0007{#qA!\u001f?\u0005\u0004\tY\u0001C\u0004\u00048y\u0002\ra!\u0007\t\u000f\r}b\b1\u0001\u0004DB!qO`B^\u0003E1\u0017N\u001c3TKJL\u0017\r\\5{KJ4uN\u001d\u000b\u0005\u00033\u0019I\r\u0003\u0004\u0004(}\u0002\r![\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014hi\u001c:\u0015\t\u0005e1q\u001a\u0005\b\u0007\u007f\u0001\u0005\u0019ABia\u0011\u0019\u0019na6\u0011\t]t8Q\u001b\t\u0005\u0003\u000b\u00199\u000e\u0002\u0007\u0004Z\u000e=\u0017\u0011!A\u0001\u0006\u0003\tYAA\u0002`IaBS\u0001QBQ\u0007g\u000bAb]3sS\u0006d\u0017N_3s\u001f\u001a$Ba!9\u0004dB1\u0011QEB\u000b\u00033Aqa!:B\u0001\u0004\u00119\"A\u0007tKJL\u0017\r\\5{KJ4\u0015K\u0014\u000b\u0007\u0007C\u001cIo!<\t\u000f\r-(\t1\u0001\u0003\u0018\u0005Y!-\u001b8eS:<g*Y7f\u0011\u001d\u0019)O\u0011a\u0001\u0005/\t\u0011c]3sS\u0006d\u0017N_3s\t\u0016$\u0018-\u001b7t+\t\u0019\u0019\u0010\u0005\u0004\u0003d\u000eU8\u0011`\u0005\u0005\u0007o\u0014)OA\u0002TKF\u00042AZB~\u0013\r\u0019i\u0010\u0018\u0002\u0012'\u0016\u0014\u0018.\u00197ju\u0016\u0014H)\u001a;bS2\u001c\u0018AE:fe&\fG.\u001b>fe\u0012+G/Y5mg\u0002\n1b]3sS\u0006d\u0017N_3sgV\u0011AQ\u0001\t\bo\nM!qCA\r\u00031\u0019XM]5bY&TXM]:!\u0003!\u0011\u0017N\u001c3j]\u001e\u001cXC\u0001C\u0007!\u0019\u0011\u0019o!>\u0005\u0010A\u0019!qU\u0002\u0002\u0013\tLg\u000eZ5oON\u0004\u0013\u0001H3ogV\u0014Xm\u00148ms\u0006cGn\\<fIN+'/[1mSj,'o\u001d\u000b\u0005\t/!i\u0002E\u0002k\t3I1\u0001b\u0007l\u0005\u0011)f.\u001b;\t\u000f\u0011}\u0011\n1\u0001\u0005\"\u0005!\u0011\u000e^3s!\u0019!\u0019\u0003\"\f\u0002\u001a9!AQ\u0005C\u0015\u001d\rIHqE\u0005\u0002Y&\u0019A1F6\u0002\u000fA\f7m[1hK&!\u0011\u0011\u0019C\u0018\u0015\r!Yc[\u0001!o\u0006\u0014h.\u00168fqB,7\r^3e\u001d>t\u0007+Z6l_N+'/[1mSj,'\u000f\u0006\u0004\u0002H\u0012UB\u0011\t\u0005\b\u0007\u007fQ\u0005\u0019\u0001C\u001ca\u0011!I\u0004\"\u0010\u0011\t]tH1\b\t\u0005\u0003\u000b!i\u0004\u0002\u0007\u0005@\u0011U\u0012\u0011!A\u0001\u0006\u0003\tYA\u0001\u0003`IE\u0002\u0004b\u0002C\"\u0015\u0002\u0007\u0011\u0011D\u0001\u0004g\u0016\u0014\u0018aE2iK\u000e\\wi\\8hY\u0016\u0004&o\u001c;pEV4G\u0003BAd\t\u0013Bq\u0001b\u0013L\u0001\u0004\u00119\"A\u0005dY\u0006\u001c8OT1nK\u0006Q1\r[3dW\u000ec\u0017m]:\u0015\r\u0005\u001dG\u0011\u000bC+\u0011\u001d!\u0019\u0006\u0014a\u0001\u0005/\ta\u0001\u001d:fM&D\bb\u0002C&\u0019\u0002\u0007!qC\u0001\u0005g>\u0014H\u000f\u0006\u0003\u0005\u000e\u0011m\u0003b\u0002C/\u001b\u0002\u0007AqL\u0001\u0003S:\u0004b\u0001b\t\u0005b\u0011=\u0011\u0002\u0002C2\t_\u0011\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00199\u0016\u0005\u0011%\u0004\u0003\u0003C6\t[\"\t(!\u0007\u000e\u0005\t]\u0017\u0002\u0002C8\u0005/\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1qa\u0011!\u0019\bb\u001e\u0011\t]tHQ\u000f\t\u0005\u0003\u000b!9\bB\u0006\u0005z=\u000b\t\u0011!A\u0003\u0002\u0005-!\u0001B0%cE\nab]3sS\u0006d\u0017N_3s\u001b\u0006\u0004\b%\u0001\u000btKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/_\u000b\u0003\t\u0003\u0003ra\u001eB\n\u0003K\u000bI\"A\u000btKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/\u001f\u0011\u00023E,\u0018nY6TKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/_\u000b\u0003\t\u0013\u0003RA[B\u000e\u00033\t!$];jG.\u001cVM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5us\u0002\n\u0011cZ3u'\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%e)\u0011\tI\u0002\"%\t\u000f\u0011ME\u000b1\u0001\u0002&\u0006\u0011\u0011\u000eZ\u0001\"SNT\u0015M^1TKJL\u0017\r\\5{CRLwN\\,be:LgnZ#oC\ndW\rZ\u0001#SNT\u0015M^1TKJL\u0017\r\\5{CRLwN\\,be:LgnZ#oC\ndW\r\u001a\u0011\u0002A%\u001cx+\u0019:oS:<wJ\u001c(p-\u0016\u0014\u0018NZ5dCRLwN\\#oC\ndW\rZ\u0001\"SN<\u0016M\u001d8j]\u001e|eNT8WKJLg-[2bi&|g.\u00128bE2,G\rI\u0001\u001bSN$\u0015n]1mY><X\r\u001a&bm\u0006\u001cVM]5bY&TXM\u001d\u000b\u0005\u0003\u000f$\t\u000bC\u0004\u0004\u0004f\u0003\r!!\u0007\u0002;MDw.\u001e7e/\u0006\u0014h.\u00112pkRT\u0015M^1TKJL\u0017\r\\5{KJ$b!a2\u0005(\u0012U\u0006b\u0002CU5\u0002\u0007A1V\u0001\u0010g\u0016\u0014\u0018.\u00197ju\u0016$7\t\\1tgB\"AQ\u0016CY!\u00119h\u0010b,\u0011\t\u0005\u0015A\u0011\u0017\u0003\r\tg#9+!A\u0001\u0002\u000b\u0005\u00111\u0002\u0002\u0005?\u0012\n4\u0007C\u0004\u0004\u0004j\u0003\r!!\u0007)\u0007i\u000b\t\u000f")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        Try try_;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.findSerializerFor(o$1).toBinary(o$1));
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return try_;
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
            try {
                if (withTransportInformation_oldInfo == null) {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
                }
                object = serializer2.fromBinary(bytes, clazz);
            }
            finally {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
            }
            return object;
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        Object object;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = Serialization.$anonfun$deserializeByteArray$1(this, serializer, bytes, manifest);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return object;
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(170).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if (serializer2 instanceof ByteBufferSerializer) {
                object = ((ByteBufferSerializer)((Object)serializer2)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object = this.deserializeByteArray(bytes, serializer2, manifest);
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        Try try_;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.serializerFor(clazz$2).fromBinary(bytes$4, (Option<Class<?>>)new Some((Object)clazz$2)));
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return try_;
    }

    public Serializer findSerializerFor(Object o) {
        if (o == null) {
            return NullSerializer$.MODULE$;
        }
        return this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer = this.serializerMap().get(clazz);
        if (serializer == null) {
            Serializer serializer2;
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.bindings().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            Some some = Seq$.MODULE$.unapplySeq((Seq)seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer2 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                scala.collection.immutable.Seq possibilitiesWithoutJavaSerializer = (scala.collection.immutable.Seq)seq.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((TraversableOnce)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            return ((Serializer)x0$3._2()).getClass().getName();
                        }
                        throw new MatchError(null);
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
                }
                serializer2 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer2;
            Serializer serializer3 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer3 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'pekko.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonPekkoSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                return ser;
            }
            return serializer3;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this, fqn, bindingName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            public final String fqn$1;
            public final String bindingName$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof NoSuchMethodException) {
                    return (B1)this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$serializerOf$1 $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            if (x1 instanceof NoSuchMethodException) {
                                NoSuchMethodException noSuchMethodException = (NoSuchMethodException)x1;
                                String string = this.$outer.bindingName$1;
                                String string2 = "";
                                if (string != null && string.equals(string2)) {
                                    throw noSuchMethodException;
                                }
                                return (B1)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)this.$outer.bindingName$1), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Serializer.class));
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            return x1 instanceof NoSuchMethodException;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 instanceof NoSuchMethodException;
            }

            public /* synthetic */ Serialization org$apache$pekko$serialization$Serialization$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
                this.bindingName$1 = bindingName$1;
            }
        });
    }

    private scala.collection.immutable.Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        if (!this.system().settings().AllowJavaSerialization()) {
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0 & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
            return;
        }
    }

    private boolean warnUnexpectedNonPekkoSerializer(Class<?> clazz, Serializer ser) {
        if (clazz.getName().startsWith("org.apache.pekko.") && !ser.getClass().getName().startsWith("org.apache.pekko.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Apache Pekko. It's not recommended to replace serializers for messages provided by Apache Pekko.", (Object)ser.getClass().getName(), (Object)clazz.getName());
            return true;
        }
        return false;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (scala.collection.immutable.Seq)((TraversableLike)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                }
            }
            return buf;
        })).to(org.apache.pekko.util.ccompat.package$.MODULE$.genericCompanionToCBF(Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer = this.quickSerializerByIdentity()[id];
            if (serializer == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            return serializer;
        }
        return (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("org.apache.pekko.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ Object $anonfun$deserializeByteArray$1(Serialization $this, Serializer serializer$2, byte[] bytes$3, String manifest$2) {
        if (serializer$2 instanceof SerializerWithStringManifest) {
            return ((SerializerWithStringManifest)serializer$2).fromBinary(bytes$3, manifest$2);
        }
        String string = manifest$2;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            return serializer$2.fromBinary(bytes$3, (Option<Class<?>>)None$.MODULE$);
        }
        Map<String, Option<Class<?>>> cache = $this.manifestCache().get();
        Option option = cache.get((Object)manifest$2);
        if (option instanceof Some) {
            Option cachedClassManifest = (Option)((Some)option).value();
            return serializer$2.fromBinary(bytes$3, cachedClassManifest);
        }
        if (None$.MODULE$.equals(option)) {
            Try try_ = $this.system().dynamicAccess().getClassFor(manifest$2, ClassTag$.MODULE$.AnyRef());
            if (try_ instanceof Success) {
                Class classManifest = (Class)((Success)try_).value();
                Some classManifestOption = new Some((Object)classManifest);
                $this.updateCache$1(cache, manifest$2, (Option)classManifestOption);
                return serializer$2.fromBinary(bytes$3, (Option<Class<?>>)classManifestOption);
            }
            if (try_ instanceof Failure) {
                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest$2).append("] for serializer with id [").append(serializer$2.identifier()).append("].").toString());
            }
            throw new MatchError(try_);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(scala.collection.immutable.Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(scala.collection.immutable.Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Class)x0$1._1()).isAssignableFrom(clazz$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        if (x0$2 != null && x0$2._2() instanceof JavaSerializer) {
            return false;
        }
        return x0$2 == null || !(x0$2._2() instanceof DisabledJavaSerializer);
    }

    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        if (check$ifrefutable$1 != null) {
            String k = (String)check$ifrefutable$1._1();
            String v = (String)check$ifrefutable$1._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            String className = (String)check$ifrefutable$2._1();
            String alias = (String)check$ifrefutable$2._2();
            if (className != null && alias != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        if (x$4 != null) {
            String className = (String)x$4._1();
            String alias = (String)x$4._2();
            if (className != null && alias != null) {
                return !alias.equals("none") && $this.checkGoogleProtobuf(className);
            }
        }
        throw new MatchError((Object)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            Class clazz = (Class)x0$3._1();
            Serializer ser = (Serializer)x0$3._2();
            return $this.warnUnexpectedNonPekkoSerializer(clazz, ser);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        if (x0$6 != null) {
            int id = x0$6._1$mcI$sp();
            Serializer ser = (Serializer)x0$6._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    /*
     * WARNING - void declaration
     */
    public Serialization(ExtendedActorSystem system) {
        void var3_3;
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            vector = (scala.collection.immutable.Seq)((SerializationSetup)((Some)option).value()).createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (scala.collection.immutable.Seq)vector.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x1.serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
                    return (B1)SerializerDetails$.MODULE$.apply(x1.alias(), new DisabledJavaSerializer(this.$outer.system()), x1.useFor());
                }
                return (B1)x1;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                if (x1 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x1.serializer())) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map result = ((Map)this.settings().Serializers().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            if (x$3 != null) {
                String k = (String)x$3._1();
                String v = (String)x$3._2();
                if (k != null && v != null) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), this.serializerOf(k, v).get());
                }
            }
            throw new MatchError(x$3);
        }, Map$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.serializerDetails().map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (Serializer)x0$1._2();
            }
            throw new MatchError(null);
        }));
        this.serializers = var3_3;
        scala.collection.immutable.Iterable fromConfig = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            if (x$5 != null) {
                String className = (String)x$5._1();
                String alias = (String)x$5._2();
                if (className != null && alias != null) {
                    return new Tuple2(this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)alias));
                }
            }
            throw new MatchError(x$5);
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq fromSettings = (scala.collection.immutable.Seq)this.serializerDetails().flatMap((Function1 & Serializable & scala.Serializable)detail -> (scala.collection.immutable.Seq)detail.useFor().map((Function1 & Serializable & scala.Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig.$plus$plus((GenTraversableOnce)fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Serializer)x0$2._2();
            }
            throw new MatchError(null);
        }));
        result2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable & scala.Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$1);
            ConcurrentHashMap map = x0$4;
            Tuple2 tuple22 = x1$1;
            if (tuple22 != null) {
                Class c = (Class)tuple22._1();
                Serializer s = (Serializer)tuple22._2();
                map.put(c, s);
                return map;
            }
            throw new MatchError((Object)tuple2);
        });
        Map zero = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}));
        this.serializerByIdentity = (Map)this.serializers().foldLeft((Object)zero, (Function2 & Serializable & scala.Serializable)(x0$5, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$5, x1$2);
            Map acc = x0$5;
            Tuple2 tuple22 = x1$2;
            if (tuple22 != null) {
                Serializer ser = (Serializer)tuple22._2();
                int id = ser.identifier();
                Option option = acc.get((Object)BoxesRunTime.boxToInteger((int)id));
                if (option instanceof Some) {
                    Serializer serializer = (Serializer)((Some)option).value();
                    if (serializer == null || !serializer.equals(ser)) {
                        throw new IllegalArgumentException(new StringBuilder(68).append("Serializer identifier [").append(id).append("] of [").append(ser.getClass().getName()).append("] ").append("is not unique. It is also used by [").append(acc.apply((Object)BoxesRunTime.boxToInteger((int)id)).getClass().getName()).append("].").toString());
                    }
                }
                return acc.updated((Object)BoxesRunTime.boxToInteger((int)id), (Object)ser);
            }
            throw new MatchError((Object)tuple2);
        });
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("pekko.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("pekko.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.address();
                }
                case 1: {
                    return this.system();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof Information)) break block3;
                    Information information = (Information)x$1;
                    Address address = this.address();
                    Address address2 = information.address();
                    if (address != null ? !((Object)address).equals(address2) : address2 != null) break block3;
                    ActorSystem actorSystem = this.system();
                    ActorSystem actorSystem2 = information.system();
                    if (actorSystem != null ? !actorSystem.equals(actorSystem2) : actorSystem2 != null) break block3;
                }
                return true;
            }
            return false;
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)package$JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    Object v = x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("pekko.actor.serializers"));
            Config bindings = config.getConfig("pekko.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

